// This file is auto-generated.
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Category;
import io.virtdata.autodoctypes.DocCtorData;
import io.virtdata.autodoctypes.DocForFuncCtor;
import io.virtdata.autodoctypes.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class MapTemplateAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "MapTemplate";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.from_long.to_collection";
  }

  public String getClassJavadoc() {
    return "Construct a {@code Map} from a set of input functions.\n"
            + "In the full four-argument form, the initial boolean argument\n"
            + "specifies whether to convert the key and value objects to String form\n"
            + "before adding them to the map. The condensed three-argument assumes that\n"
            + "a string to string map is desired by default.\n"
            + "\n"
            + "The last three parameters specify functions for the size, key, and values\n"
            + "of the map to be created. For each map created, the size is determined\n"
            + "with the size function. Then, a key and value are created for that many\n"
            + "entries using the original input value plus a relative index for both\n"
            + "the key and value functions respectively.\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.util.Map<java.lang.Object,java.lang.Object>";
  }

  public Category[] getCategories() {
    return new Category[] { Category.collections };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("MapTemplate", "", 
            new LinkedHashMap<String, String>() {{
              put("sizeFunc","java.util.function.LongToIntFunction");
              put("keyFunc","java.util.function.LongFunction<java.lang.Object>");
              put("valueFunc","java.util.function.LongFunction<java.lang.Object>");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("MapTemplate(HashRange(3,7),NumberNameToString(),LastNames())");
                add("create maps between 3 and 7 values big, with number names as the keys, and last names as the values");
              }});
            }}
          ));
          add(new DocForFuncCtor("MapTemplate", "", 
            new LinkedHashMap<String, String>() {{
              put("stringify","boolean");
              put("sizeFunc","java.util.function.LongToIntFunction");
              put("keyFunc","java.util.function.LongFunction<java.lang.Object>");
              put("valueFunc","java.util.function.LongFunction<java.lang.Object>");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("MapTemplate(false,HashRange(3,7),NumberNameToString(),HashRange(1300,1700))");
                add("create a map of size 3-7 entries, with a key of type string and a value of type int (Integer by autoboxing)");
              }});
            }}
          ));
        }};
  }
}
