// This file is auto-generated.
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Category;
import io.virtdata.autodoctypes.DocCtorData;
import io.virtdata.autodoctypes.DocForFuncCtor;
import io.virtdata.autodoctypes.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class CombinationsAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "Combinations";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.from_long.to_string";
  }

  public String getClassJavadoc() {
    return "Convert a numeric value into a code according to ASCII printable\n"
            + "characters. This is useful for creating various encodings using different\n"
            + "character ranges, etc.\n"
            + "\n"
            + "This mapper can map over the sequences of character ranges providing every unique\n"
            + "combination and then wrapping around to the beginning again.\n"
            + "It can convert between character bases with independent radix in each position.\n"
            + "Each position in the final string takes its values from a position-specific\n"
            + "character set, described by the shorthand in the examples below.\n"
            + "\n"
            + "The constructor will throw an error if the number of combinations exceeds that\n"
            + "which can be represented in a long value. (This is a very high number).\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.lang.String";
  }

  public Category[] getCategories() {
    return new Category[] {  };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("Combinations", "", 
            new LinkedHashMap<String, String>() {{
              put("spec","java.lang.String");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("Combinations('A-Z;A-Z')");
                add("a two digit alphanumeric code. Wraps at 26^2");
              }});
              add(new ArrayList<String>() {{
                add("Combinations('0-9A-F')");
                add("a single hexadecimal digit");
              }});
              add(new ArrayList<String>() {{
                add("Combinations('0123456789ABCDEF')");
                add("a single hexadecimal digit");
              }});
              add(new ArrayList<String>() {{
                add("Combinations('0-9A-F;0-9A-F;0-9A-F;0-9A-F;')");
                add("two bytes of hexadecimal");
              }});
              add(new ArrayList<String>() {{
                add("Combinations('A-9')");
                add("upper case alphanumeric");
              }});
            }}
          ));
        }};
  }
}
