/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_int.HashRange;
import io.virtdata.util.ResourceFinder;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class HashedFileExtractToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(HashedFileExtractToString.class);
    private static CharBuffer fileDataImage = null;
    private final HashRange sizeRange;
    private final HashRange positionRange;
    private int minsize;
    private int maxsize;
    private final String fileName;

    @Example(value={"HashedFileExtractToString('adventures.txt',100,200)", "return a fragment from adventures.txt between 100 and 200 characters long"})
    public HashedFileExtractToString(String fileName, int minsize, int maxsize) {
        this.fileName = fileName;
        this.minsize = minsize;
        this.maxsize = maxsize;
        this.loadData();
        this.sizeRange = new HashRange(minsize, maxsize);
        this.positionRange = new HashRange(1L, fileDataImage.limit() - maxsize - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadData() {
        if (fileDataImage != null) return;
        Class<HashedFileExtractToString> clazz = HashedFileExtractToString.class;
        synchronized (HashedFileExtractToString.class) {
            CharBuffer image;
            if (fileDataImage != null) return;
            fileDataImage = image = ResourceFinder.readDataFileToCharBuffer((String)this.fileName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String apply(long input) {
        int offset = this.positionRange.applyAsInt(input);
        int length = this.sizeRange.applyAsInt(input);
        String sub = null;
        try {
            sub = fileDataImage.subSequence(offset, offset + length).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sub;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.minsize + ":" + this.maxsize;
    }
}

