/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class SaveString
implements LongFunction<String> {
    private final String name;
    private final LongFunction<Object> nameFunc;

    @Example(value={"SaveString('foo')", "save the current String value to a named variable in this thread."})
    public SaveString(String name) {
        this.name = name;
        this.nameFunc = null;
    }

    @Example(value={"SaveString(NumberNameToString())", "save the current String value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveString(LongFunction<Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
    }

    @Override
    public String apply(long value) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(value)) : this.name;
        map.put(varname, value);
        return String.valueOf(value);
    }
}

