/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.HashRange;
import io.virtdata.libbasics.shared.from_long.to_string.HashedLineToString;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.collections})
public class HashedLineToStringSet
implements LongFunction<Set<String>> {
    private final HashedLineToString hashedLineToString;
    private final HashRange hashRange;

    @Example(value={"HashedLineToStringSet('data/variable_words.txt',2,10)", "Create a set of words sized between 2 and 10 elements"})
    public HashedLineToStringSet(String string, int n, int n2) {
        this.hashedLineToString = new HashedLineToString(string);
        this.hashRange = new HashRange(n, n2);
    }

    @Override
    public Set<String> apply(long l) {
        long l2 = this.hashRange.applyAsLong(l);
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while ((long)n < l2) {
            hashSet.add(this.hashedLineToString.apply(l + (long)n));
            ++n;
        }
        return hashSet;
    }
}

