/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.api.composers.FunctionAssembly;
import io.virtdata.util.VirtDataFunctions;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
public class MatchFunc
implements Function<String, String> {
    private final MatchEntry[] entries;
    private static final Function<String, String> PASSTHRU = string -> string;

    @Examples(value={@Example(value={"MatchFunc('.*','onevalue')", "Match all String inputs, simply returning 'onevalue' as the output value."}), @Example(value={"MatchFunc('[0-9]+',Suffix('-is-a-number'))", "Append '-is-a-number' to every input which is a sequence of digits"})})
    public MatchFunc(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new RuntimeException("You must provide 'pattern1',func1,... for an even number of arguments.");
        }
        FunctionAssembly functionAssembly = new FunctionAssembly();
        this.entries = new MatchEntry[objectArray.length / 2];
        for (int i = 0; i < objectArray.length; i += 2) {
            Pattern pattern = Pattern.compile(objectArray[i].toString());
            Object object = objectArray[i + 1];
            Function function = object instanceof String ? string -> object.toString() : (object instanceof Function ? (Function)object : (Function)VirtDataFunctions.adapt((Object)object, Function.class, String.class, (boolean)true));
            this.entries[i / 2] = new MatchEntry(pattern, function);
        }
    }

    @Override
    public String apply(String string) {
        for (MatchEntry matchEntry : this.entries) {
            Matcher matcher = matchEntry.tryMatch(string);
            if (matcher == null) continue;
            String string2 = matchEntry.f.apply(string);
            return string2;
        }
        return string;
    }

    private static class MatchEntry {
        public final Pattern pattern;
        public final Function<String, String> f;

        public MatchEntry(Pattern pattern, Function function) {
            this.pattern = pattern;
            this.f = function;
        }

        public Matcher tryMatch(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                return matcher;
            }
            return null;
        }
    }
}

