/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveString
implements Function<String, String> {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"SaveString('foo')", "save the current String value to a named variable in this thread."})
    public SaveString(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"SaveString(NumberNameToString())", "save the current String value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveString(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
    }

    @Override
    public String apply(String string) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string2 = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(string)) : this.name;
        hashMap.put(string2, string);
        return string;
    }
}

