/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.core;

import java.util.ArrayList;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeFormats {
    public static final DateTimeFormatter[] formatters = new DateTimeFormatter[]{DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSSZ").withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withChronology((Chronology)GregorianChronology.getInstance()), ISODateTimeFormat.basicDateTime().withChronology((Chronology)GregorianChronology.getInstance()), ISODateTimeFormat.basicDateTimeNoMillis().withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), ISODateTimeFormat.date().withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyyMMdd").withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyyMM").withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance()), DateTimeFormat.forPattern((String)"yyyy").withZoneUTC().withChronology((Chronology)GregorianChronology.getInstance())};
    public static DateTime gregorianCalendarStart = new DateTime(1582, 10, 15, 0, 0, DateTimeZone.UTC);

    /*
     * WARNING - void declaration
     */
    public static DateTime parseEpochTimeToDateTime(String string) {
        void var2_4;
        void var4_9;
        ArrayList<RuntimeException> arrayList = new ArrayList<RuntimeException>();
        DateTimeFormatter[] object = formatters;
        int n = object.length;
        boolean bl = false;
        while (var4_9 < n) {
            DateTimeFormatter dateTimeFormatter = object[var4_9];
            try {
                DateTime dateTime = dateTimeFormatter.withZoneUTC().parseDateTime(string);
                return dateTime;
            }
            catch (Exception exception) {
                arrayList.add(new RuntimeException("as '" + dateTimeFormatter.print((ReadableInstant)DateTime.now()) + "': " + exception.getMessage()));
                ++var4_9;
            }
        }
        String string2 = "";
        for (Exception exception : arrayList) {
            String string3 = (String)var2_4 + exception.getMessage() + "\n";
        }
        throw new RuntimeException("Unable to parse [" + string + "] with any of the parsers. exceptions:" + (String)var2_4 + ", examples of valid formats are included above");
    }

    public static long parseEpochTimeToGregorianMillis(String string) {
        DateTime dateTime = DateTimeFormats.parseEpochTimeToDateTime(string);
        return new Duration((ReadableInstant)gregorianCalendarStart, (ReadableInstant)dateTime).getMillis();
    }

    public static long parseEpochTimeToTimeUUIDTicks(String string) {
        long l = DateTimeFormats.parseEpochTimeToGregorianMillis(string);
        return l * 10000L;
    }
}

