/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_bytebuffer;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.ThreadSafeMapper;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.MessageDigestAlgorithms;

@Categories(value={Category.conversion})
@ThreadSafeMapper
public class DigestToByteBuffer
implements LongFunction<ByteBuffer> {
    private static ThreadLocal<TL_State> tl_state;

    public DigestToByteBuffer(String string) {
        for (String string2 : MessageDigestAlgorithms.values()) {
            if (!string2.equals(string)) continue;
            Supplier<MessageDigest> supplier = () -> DigestToByteBuffer.getDigest(string2);
            tl_state = ThreadLocal.withInitial(() -> new TL_State(supplier));
            break;
        }
        if (tl_state == null) {
            tl_state = ThreadLocal.withInitial(() -> new TL_State(() -> DigestToByteBuffer.getDigest(string2)));
        }
    }

    private static MessageDigest getDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("A digest of type " + string + " was not found. Select a digest type from: " + Arrays.stream(MessageDigestAlgorithms.values()).collect(Collectors.joining(",", "[", "]")));
        }
    }

    @Override
    public ByteBuffer apply(long l) {
        TL_State tL_State = tl_state.get();
        tL_State.buf.putLong(0, l);
        byte[] byArray = tL_State.digest.digest(tL_State.buf.array());
        return ByteBuffer.wrap(byArray);
    }

    private static final class TL_State {
        private final MessageDigest digest;
        private final ByteBuffer buf = ByteBuffer.allocate(8);

        public TL_State(Supplier<MessageDigest> supplier) {
            this.digest = supplier.get();
        }
    }
}

