/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.util.VirtDataFunctions;
import java.util.ArrayList;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeMapper
public class Template
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(Template.class);
    private static final String EXPR_BEGIN = "[[";
    private static final String EXPR_END = "]]";
    private static final ThreadLocal<StringBuilder> sb = ThreadLocal.withInitial(StringBuilder::new);
    private final String rawTemplate;
    private LongUnaryOperator iterOp;
    private String[] literals;
    private LongFunction<?>[] adaptedFuncs;

    @Example(value={"Template('{}-{}',Add(10),Hash())", "concatenate input+10, '-', and a pseudo-random long"})
    public Template(String string, Object ... objectArray) {
        this(true, string, objectArray);
    }

    @Example(value={"Template(true, '{}-{}', Add(10),Hash())", "throws an error, as the Add(10) function causes a narrowing conversion for a long input"})
    public Template(boolean bl, String string, Object ... objectArray) {
        this.adaptedFuncs = this.adapt(objectArray, bl);
        this.rawTemplate = string;
        this.literals = this.parseTemplate(string, objectArray.length);
    }

    private LongFunction<?>[] adapt(Object[] objectArray, boolean bl) {
        ArrayList<LongFunction> arrayList = new ArrayList<LongFunction>();
        for (Object object : objectArray) {
            LongFunction longFunction = (LongFunction)VirtDataFunctions.adapt((Object)object, LongFunction.class, Object.class, (boolean)bl);
            arrayList.add(longFunction);
        }
        return arrayList.toArray(new LongFunction[0]);
    }

    public Template(LongUnaryOperator longUnaryOperator, String string, LongFunction<?> ... longFunctionArray) {
        this(string, longFunctionArray);
        this.iterOp = longUnaryOperator;
    }

    private String[] parseTemplate(String string, int n) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            Pattern pattern = Pattern.compile("\\{}");
            Matcher matcher = pattern.matcher(string);
            int n2 = 0;
            while (matcher.find()) {
                arrayList.add(string.substring(n2, matcher.start()));
                n2 = matcher.end();
            }
            arrayList.add(string.substring(n2));
            if (arrayList.size() != n + 1) {
                throw new RuntimeException("The number of {} place holders in '" + string + "' should equal the number of functions.");
            }
            return arrayList.toArray(new String[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String apply(long l) {
        StringBuilder stringBuilder = sb.get();
        stringBuilder.setLength(0);
        stringBuilder.append(this.literals[0]);
        if (this.literals.length > 1) {
            for (int i = 0; i < this.adaptedFuncs.length; ++i) {
                long l2 = this.iterOp != null ? this.iterOp.applyAsLong(l + (long)i) : l + (long)i;
                String string = String.valueOf(this.adaptedFuncs[i].apply(l2));
                stringBuilder.append(string);
                stringBuilder.append(this.literals[i + 1]);
            }
        }
        return stringBuilder.toString();
    }
}

