/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.nondeterministic.to_int;

import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.LongToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
public class ThreadNum
implements LongToIntFunction {
    private static final Pattern pattern = Pattern.compile("^.*?(\\d+).*$");
    private ThreadLocal<Integer> threadLocalInt = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            Matcher matcher = pattern.matcher(Thread.currentThread().getName());
            if (matcher.matches()) {
                return Integer.valueOf(matcher.group(1));
            }
            throw new RuntimeException("Unable to match a digit sequence in thread name:" + Thread.currentThread().getName());
        }
    };

    @Override
    public int applyAsInt(long l) {
        return this.threadLocalInt.get();
    }
}

