/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.LongFunction;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveFloat
implements LongFunction<Float> {
    private final String name;
    private final LongFunction<Object> nameFunc;

    @Example(value={"SaveFloat('foo')", "save the current float value to a named variable in this thread."})
    public SaveFloat(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"SaveFloat(NumberNameToString())", "save the current float value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveFloat(LongFunction<Object> longFunction) {
        this.name = null;
        this.nameFunc = longFunction;
    }

    @Override
    public Float apply(long l) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(l)) : this.name;
        hashMap.put(string, l);
        return Float.valueOf(l);
    }
}

