/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_int;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.unary_int.Hash;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
public class HashRange
implements IntUnaryOperator {
    private final int minValue;
    private final int width;
    private final Hash hash = new Hash();

    public HashRange(int n) {
        this.minValue = 0;
        this.width = n;
    }

    public HashRange(int n, int n2) {
        this.minValue = n;
        if (n2 <= n) {
            throw new RuntimeException("HashRange must have min and max value in that order.");
        }
        this.width = n2 - n;
    }

    @Override
    public int applyAsInt(int n) {
        return this.minValue + (this.hash.applyAsInt(n) & this.width);
    }
}

