// This file is auto-generated.
package io.virtdata.libbasics.shared.from_long.to_unset;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class UnsetAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "Unset";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.from_long.to_unset";
  }

  public String getClassJavadoc() {
    return "Always yields the VALUE.unset value, which signals to\n"
            + "any consumers that the value provided should be considered\n"
            + "undefined for any operation. This is distinct from functions\n"
            + "which return a null, which is considered an actual value to\n"
            + "be acted upon.\n"
            + "\n"
            + "It is deemed an error for any downstream user of this library\n"
            + "to do anything with VALUE.unset besides explicitly acting like\n"
            + "it wasn't provided. That is the point of VALUE.unset.\n"
            + "\n"
            + "The purpose of having such a value in this library is to provide\n"
            + "a value type to help bridge between functional flows and imperative\n"
            + "run-times. Without such a value, it would be difficult to simulate\n"
            + "value streams in which some of the time values are set and other\n"
            + "times they are not.\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.lang.Object";
  }

  public Category[] getCategories() {
    return new Category[] { Category.nulls };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("Unset", "", 
            new LinkedHashMap<String, String>() {{
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
