/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_collection;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.HashMap;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class Map
implements LongFunction<java.util.Map<Object, Object>> {
    private final LongToIntFunction sizeFunc;
    private final LongFunction[] keyFuncs;
    private final LongFunction[] valueFuncs;
    private final Mode mode;

    @Example(value={"Map(HashRange(3,7),NumberNameToString(),HashRange(1300,1700))", "create a map of size 3-7 entries, with a key of type string and a value of type int (Integer by autoboxing)"})
    public Map(LongToIntFunction longToIntFunction, LongFunction<Object> longFunction, LongFunction<Object> longFunction2) {
        this.mode = Mode.VarSized;
        this.sizeFunc = longToIntFunction;
        this.keyFuncs = new LongFunction[1];
        this.keyFuncs[0] = longFunction;
        this.valueFuncs = new LongFunction[1];
        this.valueFuncs[0] = longFunction2;
    }

    @SafeVarargs
    @Example(value={"Map(NumberNameToString(),HashRange(1300,1700),NumberNameToString(),HashRange(3,7))", "create a map of size 2, with a specific function for each key and each value"})
    public Map(LongFunction<Object> ... longFunctionArray) {
        this.mode = Mode.Tuples;
        if (longFunctionArray.length % 2 != 0) {
            throw new RuntimeException("An even number of functions must be provided.");
        }
        int n = longFunctionArray.length / 2;
        this.sizeFunc = l -> n;
        this.keyFuncs = new LongFunction[n];
        this.valueFuncs = new LongFunction[n];
        for (int i = 0; i < n; ++i) {
            this.keyFuncs[i] = longFunctionArray[i << 1];
            this.valueFuncs[i] = longFunctionArray[(i << 1) + 1];
        }
    }

    @Override
    public java.util.Map<Object, Object> apply(long l) {
        int n = this.sizeFunc.applyAsInt(l);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(n);
        switch (this.mode) {
            case VarSized: {
                for (int i = 0; i < n; ++i) {
                    Object r = this.keyFuncs[0].apply(l + (long)i);
                    Object r2 = this.valueFuncs[0].apply(l + (long)i);
                    hashMap.put(r, r2);
                }
                break;
            }
            case Tuples: {
                for (int i = 0; i < this.keyFuncs.length; ++i) {
                    Object r = this.keyFuncs[i].apply(l + (long)i);
                    Object r3 = this.valueFuncs[i].apply(l + (long)i);
                    hashMap.put(r, r3);
                }
                break;
            }
        }
        return hashMap;
    }

    private static enum Mode {
        VarSized,
        Tuples;

    }
}

