/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_string;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_double.HashedDoubleRange;
import java.util.ArrayList;
import java.util.function.LongFunction;

@ThreadSafeMapper
public class WeightedStrings
implements LongFunction<String> {
    private final String valuesAndWeights;
    private double[] unitWeights;
    private double[] cumulativeWeights;
    private HashedDoubleRange unitRange = new HashedDoubleRange(0.0, 1.0);
    private String[] values;

    public WeightedStrings(String string) {
        this.valuesAndWeights = string;
        this.parseWeights();
    }

    private void parseWeights() {
        String[] stringArray = this.valuesAndWeights.split("[;,]");
        if (stringArray.length == 0) {
            throw new RuntimeException("No pairs were found. They must be separated by ';'");
        }
        this.values = new String[stringArray.length];
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":", 2);
            if (stringArray2.length == 2) {
                arrayList.add(Double.valueOf(stringArray2[1].trim()));
            } else {
                arrayList.add(1.0);
            }
            this.values[i] = stringArray2[0].trim();
        }
        double d3 = arrayList.stream().mapToDouble(d -> d).sum();
        this.unitWeights = arrayList.stream().mapToDouble(d2 -> d2 / d3).toArray();
        this.cumulativeWeights = new double[this.unitWeights.length];
        double d4 = 0.0;
        for (int i = 0; i < this.unitWeights.length; ++i) {
            this.cumulativeWeights[i] = d4 += this.unitWeights[i];
        }
    }

    @Override
    public String apply(long l) {
        double d = this.unitRange.applyAsDouble(l);
        for (int i = 0; i < this.cumulativeWeights.length; ++i) {
            if (!(d < this.cumulativeWeights[i])) continue;
            return this.values[i];
        }
        throw new RuntimeException("sampled value '" + d + "' was not below final cumulative weight: " + this.cumulativeWeights[this.cumulativeWeights.length - 1]);
    }
}

