/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.state})
public class Swap
implements Function<Object, Object> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final Object defaultValue;

    @Example(value={"Swap('foo')", "for the current thread, swap the input value with the named variable and returned the named variable"})
    public Swap(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = null;
    }

    @Example(value={"Swap('foo','examplevalue')", "for the current thread, swap the input value with the named variable and returned the named variable, or return the default value if the named value is not defined."})
    public Swap(String string, Object object) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = object;
    }

    @Example(value={"Swap(NumberNameToString())", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function."})
    public Swap(Function<Object, Object> function) {
        this.nameFunc = function;
        this.name = null;
        this.defaultValue = null;
    }

    @Example(value={"Swap(NumberNameToString(),'examplevalue')", "for the current thread, swap the input value with the named variable and returned the named variable, where the variable name is generated by the provided function, or the default value if the named value is not defined."})
    public Swap(Function<Object, Object> function, Object object) {
        this.nameFunc = function;
        this.name = null;
        this.defaultValue = object;
    }

    @Override
    public Object apply(Object object) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(object)) : this.name;
        Object object2 = hashMap.get(string);
        hashMap.put(this.name, object);
        return object2 != null ? object2 : this.defaultValue;
    }
}

