// This file is auto-generated.
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class LoadLongAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "LoadLong";
  }

  public String getPackageName() {
    return "io.virtdata.libbasics.shared.stateful";
  }

  public String getClassJavadoc() {
    return "Load a value from a named thread-local variable, where the variable\n"
            + "name is fixed or a generated variable name from a provided function.\n"
            + "If the named variable is not defined, then the default value is returned.\n";
  }

  public String getInType() {
    return "java.lang.Object";
  }

  public String getOutType() {
    return "java.lang.Long";
  }

  public Category[] getCategories() {
    return new Category[] { Category.state };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("LoadLong", "", 
            new LinkedHashMap<String, String>() {{
              put("name","java.lang.String");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadLong('foo',42L)");
                add("for the current thread, load a long value from the named variable.");
              }});
            }}
          ));
          add(new DocForFuncCtor("LoadLong", "", 
            new LinkedHashMap<String, String>() {{
              put("name","java.lang.String");
              put("defaultValue","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadLong('foo',42L)");
                add("for the current thread, load a long value from the named variable, or the default value if the named variable is not defined.");
              }});
            }}
          ));
          add(new DocForFuncCtor("LoadLong", "", 
            new LinkedHashMap<String, String>() {{
              put("nameFunc","java.util.function.Function<java.lang.Object,java.lang.Object>");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadLong(NumberNameToString(),42L)");
                add("for the current thread, load a long value from the named variable,where the variable name is provided by a function.");
              }});
            }}
          ));
          add(new DocForFuncCtor("LoadLong", "", 
            new LinkedHashMap<String, String>() {{
              put("nameFunc","java.util.function.Function<java.lang.Object,java.lang.Object>");
              put("defaultValue","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadLong(NumberNameToString(),42L)");
                add("for the current thread, load a long value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined.");
              }});
            }}
          ));
        }};
  }
}
