/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_double.to_double;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.DoubleUnaryOperator;

@ThreadSafeMapper
public class Clamp
implements DoubleUnaryOperator {
    private final double min;
    private final double max;

    @Example(value={"Clamp(1.0D,9.0D)", "clamp output values between the range [1.0D, 9.0D], inclusive"})
    public Clamp(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    @Override
    public double applyAsDouble(double d) {
        return Double.min(this.max, Double.max(this.min, d));
    }
}

