/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadFloat
implements Function<Object, Float> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final float defaultValue;

    @Example(value={"LoadFloat('foo')", "for the current thread, load a float value from the named variable."})
    public LoadFloat(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0.0f;
    }

    @Example(value={"LoadFloat('foo',23F)", "for the current thread, load a float value from the named variable,or the default value if the named variable is not defined."})
    public LoadFloat(String string, float f) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = f;
    }

    @Example(value={"LoadFloat(NumberNameToString())", "for the current thread, load a float value from the named variable,where the variable name is provided by a function."})
    public LoadFloat(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = 0.0f;
    }

    @Example(value={"LoadFloat(NumberNameToString(),23F)", "for the current thread, load a float value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadFloat(Function<Object, Object> function, float f) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = f;
    }

    @Override
    public Float apply(Object object) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(object)) : this.name;
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        Object object2 = hashMap.getOrDefault(string, Float.valueOf(this.defaultValue));
        return (Float)object2;
    }
}

