/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful.from_long;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveInteger
implements LongToIntFunction {
    private final String name;
    private final LongFunction<Object> nameFunc;

    @Example(value={"SaveInteger('foo')", "save the current integer value to a named variable in this thread."})
    public SaveInteger(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"SaveInteger(NumberNameToString())", "save the current integer value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveInteger(LongFunction<Object> longFunction) {
        this.name = null;
        this.nameFunc = longFunction;
    }

    @Override
    public int applyAsInt(long l) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(l)) : this.name;
        SharedState.tl_ObjectMap.get().put(string, l);
        return (int)l;
    }
}

