/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_int;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
public class CycleRange
implements IntUnaryOperator {
    private final int minValue;
    private final int width;

    @Example(value={"CycleRange(34)", "add a rotating value between 0 and 34 to the input"})
    public CycleRange(int n) {
        this(0, n);
    }

    public CycleRange(int n, int n2) {
        this.minValue = n;
        if (n2 < n) {
            throw new RuntimeException("CycleRange must have min and max value in that order.");
        }
        this.width = n2 - n;
    }

    @Override
    public int applyAsInt(int n) {
        return this.minValue + n % this.width;
    }
}

