/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.unary_int;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.core.murmur.Murmur3F;
import java.nio.ByteBuffer;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
public class SignedHash
implements IntUnaryOperator {
    private ThreadLocal<Murmur3F> murmur3f_TL = ThreadLocal.withInitial(Murmur3F::new);

    @Override
    public int applyAsInt(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        Murmur3F murmur3F = this.murmur3f_TL.get();
        murmur3F.reset();
        byteBuffer.putInt(0, n);
        byteBuffer.putInt(4, n);
        byteBuffer.position(0);
        murmur3F.update(byteBuffer.array());
        return (int)murmur3F.getValue() & Integer.MAX_VALUE;
    }
}

