/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.api.config.ConfigAware;
import io.virtdata.api.config.ConfigModel;
import io.virtdata.api.config.MutableConfigModel;
import java.util.Map;
import java.util.function.Function;

@ThreadSafeMapper
public class LoadElement
implements Function<Object, Object>,
ConfigAware {
    private final String varname;
    private final Object defaultValue;
    private final String mapname;
    private Map<String, ?> vars;

    @Example(value={"LoadElement('varname','vars','defaultvalue')", "Load the varable 'varname' from a map named 'vars', or provide 'defaultvalue' if neither is provided"})
    public LoadElement(String string, String string2, Object object) {
        this.mapname = string2;
        this.varname = string;
        this.defaultValue = object;
    }

    @Override
    public Object apply(Object object) {
        if (this.vars == null) {
            return this.defaultValue;
        }
        Object obj = this.vars.get(this.varname);
        return obj != null ? obj : this.defaultValue;
    }

    public void applyConfig(Map<String, ?> map) {
        Map map2 = (Map)map.get(this.mapname);
        if (map2 != null) {
            this.vars = map2;
        }
    }

    public ConfigModel getConfigModel() {
        return new MutableConfigModel().add("<mapname>", Map.class);
    }
}

