/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_double;

import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import java.util.function.LongToDoubleFunction;

@ThreadSafeMapper
public class HashedRangedToNonuniformDouble
implements LongToDoubleFunction {
    private final long min;
    private final long max;
    private final double length;
    private final Hash hash = new Hash();

    public HashedRangedToNonuniformDouble(long l, long l2) {
        if (l2 <= l) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = l;
        this.max = l2;
        this.length = (double)l2 - (double)l;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }

    @Override
    public double applyAsDouble(long l) {
        long l2 = this.hash.applyAsLong(l);
        double d = Math.abs(Double.longBitsToDouble(l2));
        while (!Double.isFinite(d)) {
            l2 = this.hash.applyAsLong(++l);
            d = Math.abs(Double.longBitsToDouble(l2));
        }
        d %= this.length;
        return d += (double)this.min;
    }
}

