/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_int;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
public class HashRange
implements LongToIntFunction {
    private final long minValue;
    private final long width;
    private final Hash hash = new Hash();

    @Example(value={"HashRange(32L)", "map the input to a number in the range 0-31, inclusive, of type int"})
    public HashRange(int n) {
        this.width = n;
        this.minValue = 0L;
    }

    @Example(value={"HashRange(35L,39L)", "map the input to a number in the range 35-38, inclusive, of type int"})
    public HashRange(int n, int n2) {
        this.minValue = n;
        if (n2 <= n) {
            throw new RuntimeException("HashRange must have min and max value in that order.");
        }
        this.width = n2 - n;
    }

    @Override
    public int applyAsInt(long l) {
        return (int)(this.minValue + this.hash.applyAsLong(l) % this.width & Integer.MAX_VALUE);
    }
}

