/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_string.to_epoch;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.Function;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Categories(value={Category.datetime})
@ThreadSafeMapper
public class DateTimeParser
implements Function<String, DateTime> {
    private final DateTimeFormatter dateTimeFormatter;
    private final DateTime defaultTime;

    @Example(value={"DateTimeParser()", "parse any date in the yyyy-MM-dd HH:mm:ss.SSSZ format"})
    public DateTimeParser() {
        this("yyyy-MM-dd HH:mm:ss.SSSZ", null);
    }

    @Example(value={"DateTimeParser('yyyy-MM-dd')", "parse any date in the yyyy-MM-dd format"})
    public DateTimeParser(String string) {
        this(string, null);
    }

    @Example(value={"DateTimeParser('yyyy-MM-dd','1999-12-31')", "parse any date in the yyyy-MM-dd format, or return the DateTime represented by 1999-12-31"})
    public DateTimeParser(String string, String string2) {
        this.dateTimeFormatter = DateTimeFormat.forPattern((String)string).withChronology((Chronology)GregorianChronology.getInstance());
        if (string2 != null) {
            try {
                this.defaultTime = this.dateTimeFormatter.parseDateTime(string2);
            }
            catch (Exception exception) {
                throw new RuntimeException("DateTimeParser with pattern '" + string + "' did  not validate with default provided: '" + string2 + "'");
            }
        } else {
            this.defaultTime = null;
        }
    }

    @Override
    public DateTime apply(String string) {
        try {
            DateTime dateTime = this.dateTimeFormatter.parseDateTime(string);
            return dateTime;
        }
        catch (Exception exception) {
            if (this.defaultTime != null) {
                return this.defaultTime;
            }
            throw new RuntimeException("Failed to parse '" + string + "' with '" + this.dateTimeFormatter + "'");
        }
    }
}

