/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadDouble
implements Function<Object, Double> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final double defaultValue;

    @Example(value={"LoadDouble('foo')", "for the current thread, load a double value from the named variable."})
    public LoadDouble(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0.0;
    }

    @Example(value={"LoadDouble('foo',23D)", "for the current thread, load a double value from the named variable,or the default value if the named variable is not defined."})
    public LoadDouble(String string, double d) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = d;
    }

    @Example(value={"LoadDouble(NumberNameToString())", "for the current thread, load a double value from the named variable, where the variable name is provided by a function."})
    public LoadDouble(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = 0.0;
    }

    @Example(value={"LoadDouble(NumberNameToString(),23D)", "for the current thread, load a double value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadDouble(Function<Object, Object> function, double d) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = d;
    }

    @Override
    public Double apply(Object object) {
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(object)) : this.name;
        Object object2 = hashMap.getOrDefault(string, this.defaultValue);
        return (Double)object2;
    }
}

