/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.stateful;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class LoadLong
implements Function<Object, Long> {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private long defaultValue;

    @Example(value={"LoadLong('foo',42L)", "for the current thread, load a long value from the named variable."})
    public LoadLong(String string) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = 0L;
    }

    @Example(value={"LoadLong('foo',42L)", "for the current thread, load a long value from the named variable, or the default value if the named variable is not defined."})
    public LoadLong(String string, long l) {
        this.name = string;
        this.nameFunc = null;
        this.defaultValue = l;
    }

    @Example(value={"LoadLong(NumberNameToString(),42L)", "for the current thread, load a long value from the named variable,where the variable name is provided by a function."})
    public LoadLong(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = 0L;
    }

    @Example(value={"LoadLong(NumberNameToString(),42L)", "for the current thread, load a long value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined."})
    public LoadLong(Function<Object, Object> function, long l) {
        this.name = null;
        this.nameFunc = function;
        this.defaultValue = l;
    }

    @Override
    public Long apply(Object object) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(object)) : this.name;
        HashMap<String, Object> hashMap = SharedState.tl_ObjectMap.get();
        Object object2 = hashMap.getOrDefault(string, this.defaultValue);
        return (Long)object2;
    }
}

