/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.core.stathelpers;

import io.virtdata.libbasics.core.stathelpers.ElemProbD;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AliasElementSampler<T>
implements DoubleFunction<T> {
    private double[] biases;
    private T[] elements;
    private double slotCount;

    AliasElementSampler(double[] dArray, T[] TArray) {
        this.biases = dArray;
        this.elements = TArray;
    }

    AliasElementSampler(Collection<T> collection, Function<T, Double> function) {
        this(collection.stream().map(object -> new ElemProbD<Object>(object, (Double)function.apply(object))).collect(Collectors.toList()));
    }

    public AliasElementSampler(List<ElemProbD<T>> list) {
        int n;
        Object object;
        int n2 = list.size();
        LinkedList<ElemProbD> linkedList = new LinkedList<ElemProbD>();
        LinkedList linkedList2 = new LinkedList();
        ArrayList arrayList = new ArrayList();
        double d = list.stream().mapToDouble(ElemProbD::getProbability).sum();
        list = list.stream().map(elemProbD -> new ElemProbD(elemProbD.getElement(), elemProbD.getProbability() / d * (double)n2)).collect(Collectors.toList());
        for (ElemProbD<T> elemProbD2 : list) {
            (elemProbD2.getProbability() < 1.0 ? linkedList : linkedList2).addLast(elemProbD2);
        }
        while (linkedList.peekFirst() != null && linkedList2.peekFirst() != null) {
            object = (ElemProbD)linkedList.removeFirst();
            ElemProbD elemProbD2 = (ElemProbD)linkedList2.removeFirst();
            arrayList.add(new Slot(elemProbD2.getElement(), ((ElemProbD)object).getElement(), ((ElemProbD)object).getProbability()));
            elemProbD2.setProbability(elemProbD2.getProbability() + ((ElemProbD)object).getProbability() - 1.0);
            (elemProbD2.getProbability() < 1.0 ? linkedList : linkedList2).addLast(elemProbD2);
        }
        while (linkedList2.peekFirst() != null) {
            object = (ElemProbD)linkedList2.removeFirst();
            arrayList.add(new Slot(((ElemProbD)object).getElement(), ((ElemProbD)object).getElement(), 1.0));
        }
        while (linkedList.peekFirst() != null) {
            object = (ElemProbD)linkedList.removeFirst();
            arrayList.add(new Slot(((ElemProbD)object).getElement(), ((ElemProbD)object).getElement(), 1.0));
        }
        if (arrayList.size() != n2) {
            throw new RuntimeException("basis for average probability is incorrect, because only " + arrayList.size() + " slotCount of " + n2 + " were created.");
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((Slot)arrayList.get(n)).rescale(n, n + 1);
        }
        this.biases = new double[arrayList.size()];
        this.elements = new Object[this.biases.length * 2];
        for (n = 0; n < this.biases.length; ++n) {
            this.biases[n] = ((Slot)arrayList.get((int)n)).botProb;
            this.elements[n * 2] = ((Slot)arrayList.get((int)n)).botItx;
            this.elements[n * 2 + 1] = ((Slot)arrayList.get((int)n)).topIdx;
        }
        this.slotCount = this.biases.length;
    }

    @Override
    public T apply(double d) {
        double d2 = d * this.slotCount;
        int n = (int)d2;
        double d3 = this.biases[n];
        int n2 = d2 > d3 ? (n << 1) + 1 : n << 1;
        T t = this.elements[n2];
        return t;
    }

    public static interface Weighted {
        public double getWeight();
    }

    private static class Slot<T> {
        public T topIdx;
        public T botItx;
        public double botProb;

        public Slot(T t, T t2, double d) {
            this.topIdx = t;
            this.botItx = t2;
            this.botProb = d;
        }

        public String toString() {
            return "top:" + this.topIdx + ", bot:" + this.botItx + ", botProb: " + this.botProb;
        }

        public Slot rescale(double d, double d2) {
            this.botProb = d + this.botProb * (d2 - d);
            return this;
        }
    }
}

