/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.distributions;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.stathelpers.AliasSamplerDoubleInt;
import io.virtdata.libbasics.core.stathelpers.EvProbD;
import io.virtdata.libbasics.shared.from_long.to_long.Hash;
import io.virtdata.util.VirtDataResources;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.math3.stat.Frequency;

@Categories(value={Category.general})
@ThreadSafeMapper
public class DelimFrequencySampler
implements LongFunction<String> {
    private final String filename;
    private final String columnName;
    private final String[] lines;
    private final AliasSamplerDoubleInt sampler;
    private final char delimiter;
    private Hash hash;

    @Example(value={"DelimFrequencySampler('values.csv','modelno', '|')", "Read values.csv, count the frequency of values in 'modelno' column, and sample from this column proportionally"})
    public DelimFrequencySampler(String string, String string2, char c) {
        this.filename = string;
        this.columnName = string2;
        this.delimiter = c;
        this.hash = new Hash();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<EvProbD> arrayList = new ArrayList<EvProbD>();
        CSVParser cSVParser = VirtDataResources.readDelimFile((String)string, (char)c, (String[])new String[0]);
        Frequency frequency = new Frequency();
        for (Object object : cSVParser) {
            String string3 = object.get(string2);
            frequency.addValue((Comparable)((Object)string3));
            hashSet.add(string3);
        }
        int n = 0;
        for (String string3 : hashSet) {
            arrayList.add(new EvProbD(n++, frequency.getCount((Comparable)((Object)string3))));
        }
        this.sampler = new AliasSamplerDoubleInt(arrayList);
        this.lines = hashSet.toArray(new String[0]);
    }

    @Override
    public String apply(long l) {
        if (this.hash != null) {
            l = this.hash.applyAsLong(l);
        }
        double d = (double)l / 9.223372036854776E18;
        int n = this.sampler.applyAsInt(d);
        return this.lines[n];
    }
}

