/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_double.to_double;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.threadstate.SharedState;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class Save
implements DoubleUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"Save('foo')", "for the current thread, save the current double value to the named variable."})
    public Save(String string) {
        this.name = string;
        this.nameFunc = null;
    }

    @Example(value={"Save(NumberNameToString())", "for the current thread, save the current double value to the name 'foo' in this thread, where the variable name is provided by a function."})
    public Save(Function<Object, Object> function) {
        this.name = null;
        this.nameFunc = function;
    }

    @Override
    public double applyAsDouble(double d) {
        String string = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(d)) : this.name;
        SharedState.tl_ObjectMap.get().put(string, d);
        return d;
    }
}

