/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_long.to_time_types;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.libbasics.core.DateTimeFormats;
import java.util.UUID;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.datetime})
public class ToFinestTimeUUID
implements LongFunction<UUID> {
    private final long node;
    private final long clock;
    private final long baseTicks;

    @Example(value={"ToFinestTimeUUID()", "basetime 0, computed node data, empty clock data"})
    public ToFinestTimeUUID() {
        this.node = 0L;
        this.clock = 0L;
        this.baseTicks = 0L;
    }

    @Example(value={"ToFinestTimeUUID(5234)", "basetime 0, specified node data (5234), empty clock data"})
    public ToFinestTimeUUID(long l) {
        this.node = l;
        this.clock = 0L;
        this.baseTicks = 0L;
    }

    @Example(value={"ToFinestTimeUUID(31,337)", "basetime 0, specified node data (31) and clock data (337)"})
    public ToFinestTimeUUID(long l, long l2) {
        this.node = l;
        this.clock = l2;
        this.baseTicks = 0L;
    }

    @Example(value={"ToFinestTimeUUID('2017-01-01T23:59:59')", "specified basetime, computed node data, empty clock data"})
    public ToFinestTimeUUID(String string) {
        this.node = 0L;
        this.clock = 0L;
        this.baseTicks = DateTimeFormats.parseEpochTimeToTimeUUIDTicks(string);
    }

    @Example(value={"ToFinestTimeUUID('2012',12345)", "basetime at start if 2012, with node data 12345, empty clock data"})
    public ToFinestTimeUUID(String string, long l) {
        this.node = l;
        this.clock = 0L;
        this.baseTicks = DateTimeFormats.parseEpochTimeToTimeUUIDTicks(string);
    }

    @Example(value={"ToFinestTimeUUID('20171231T1015.243',123,456)", "ms basetime, specified node and clock data"})
    public ToFinestTimeUUID(String string, long l, long l2) {
        this.node = l;
        this.clock = l2;
        this.baseTicks = DateTimeFormats.parseEpochTimeToTimeUUIDTicks(string);
    }

    private static long msbBitsFor(long l) {
        return 0x1000L | (0xFFF000000000000L & l) >>> 48 | (0xFFFF00000000L & l) >>> 16 | (0xFFFFFFFFL & l) << 32;
    }

    private static long lsbBitsFor(long l, long l2) {
        return (l2 & 0x3FFFL) << 48 | Long.MIN_VALUE | l;
    }

    @Override
    public UUID apply(long l) {
        return new UUID(ToFinestTimeUUID.msbBitsFor(l + this.baseTicks), ToFinestTimeUUID.lsbBitsFor(this.node, this.clock));
    }
}

