/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.libbasics.shared.from_string;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
public class MatchRegex
implements Function<String, String> {
    private final MatchEntry[] entries;
    private static final Function<String, String> PASSTHRU = string -> string;

    @Examples(value={@Example(value={"MatchRegex('.*(25|6to4).*','$1')", "Match 25 or 6 to 4 and set the output to only that"}), @Example(value={"MatchRegex('([0-9]+)-([0-9]+)-([0-9]+)','$1 $2 $3'", "replaced dashes with spaces in a 10 digit US phone number."})})
    public MatchRegex(String ... stringArray) {
        if (stringArray.length % 2 != 0) {
            throw new RuntimeException("You must provide 'pattern1',func1,... for an even number of arguments.");
        }
        this.entries = new MatchEntry[stringArray.length / 2];
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i].toString();
            String string2 = stringArray[i + 1];
            this.entries[i / 2] = new MatchEntry(string, string2);
        }
    }

    @Override
    public String apply(String string) {
        for (MatchEntry matchEntry : this.entries) {
            Matcher matcher = matchEntry.tryMatch(string);
            if (matcher == null) continue;
            String string2 = matcher.replaceAll(matchEntry.replacement);
            return string2;
        }
        return string;
    }

    private static class MatchEntry {
        public final Pattern pattern;
        public final String replacement;

        public MatchEntry(String string, String string2) {
            this.pattern = Pattern.compile(string);
            this.replacement = string2;
        }

        public Matcher tryMatch(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                return matcher;
            }
            return null;
        }
    }
}

