/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.long_int;

import io.virtdata.discrete.common.DiscreteLongIntSampler;
import io.virtdata.discrete.common.IntegerDistributionICDSource;
import io.virtdata.discrete.common.InterpolatingLongIntSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongToIntFunction;
import org.apache.commons.statistics.distribution.DiscreteDistribution;

public class LongToIntDiscreteCurve
implements LongToIntFunction {
    private DiscreteDistribution distribution;
    private LongToIntFunction function;
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add("compute");
            this.add("interpolate");
            this.add("map");
            this.add("hash");
        }
    };

    public LongToIntDiscreteCurve(DiscreteDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        IntegerDistributionICDSource icdSource = new IntegerDistributionICDSource(distribution);
        if (mods.contains("hash") && mods.contains("map")) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains("interpolate") && mods.contains("compute")) {
            throw new RuntimeException("mods must not contain both interpolate and compute");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains("hash") || !mods.contains("map");
        boolean interpolate = mods.contains("interpolate") || !mods.contains("compute");
        this.function = interpolate ? new InterpolatingLongIntSampler(icdSource, 1000, hash) : new DiscreteLongIntSampler(icdSource, hash);
    }

    @Override
    public int applyAsInt(long value) {
        return this.function.applyAsInt(value);
    }
}

