/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.long_long;

import io.virtdata.discrete.common.DiscreteLongLongSampler;
import io.virtdata.discrete.common.IntegerDistributionICDSource;
import io.virtdata.discrete.common.InterpolatingLongLongSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongUnaryOperator;
import org.apache.commons.statistics.distribution.DiscreteDistribution;

public class LongToLongDiscreteCurve
implements LongUnaryOperator {
    private DiscreteDistribution distribution;
    private LongUnaryOperator function;
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add("compute");
            this.add("interpolate");
            this.add("map");
            this.add("hash");
        }
    };

    public LongToLongDiscreteCurve(DiscreteDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        IntegerDistributionICDSource icdSource = new IntegerDistributionICDSource(distribution);
        if (mods.contains("hash") && mods.contains("map")) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains("interpolate") && mods.contains("compute")) {
            throw new RuntimeException("mods must not contain both interpolate and compute");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains("hash") || !mods.contains("map");
        boolean interpolate = mods.contains("interpolate") || !mods.contains("compute");
        this.function = interpolate ? new InterpolatingLongLongSampler(icdSource, 1000, hash) : new DiscreteLongLongSampler(icdSource, hash);
    }

    @Override
    public long applyAsLong(long operand) {
        return this.function.applyAsLong(operand);
    }
}

