/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.geometry.Point;
import org.apache.commons.math4.geometry.Vector;
import org.apache.commons.math4.geometry.euclidean.oned.Euclidean1D;
import org.apache.commons.math4.geometry.euclidean.threed.Cartesian3D;
import org.apache.commons.math4.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math4.geometry.euclidean.threed.Line;
import org.apache.commons.math4.geometry.euclidean.threed.Plane;
import org.apache.commons.math4.geometry.euclidean.threed.Rotation;
import org.apache.commons.math4.geometry.euclidean.threed.SubPlane;
import org.apache.commons.math4.geometry.euclidean.twod.Cartesian2D;
import org.apache.commons.math4.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math4.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math4.geometry.euclidean.twod.SubLine;
import org.apache.commons.math4.geometry.partitioning.AbstractRegion;
import org.apache.commons.math4.geometry.partitioning.BSPTree;
import org.apache.commons.math4.geometry.partitioning.BSPTreeVisitor;
import org.apache.commons.math4.geometry.partitioning.BoundaryAttribute;
import org.apache.commons.math4.geometry.partitioning.Hyperplane;
import org.apache.commons.math4.geometry.partitioning.Region;
import org.apache.commons.math4.geometry.partitioning.RegionFactory;
import org.apache.commons.math4.geometry.partitioning.SubHyperplane;
import org.apache.commons.math4.geometry.partitioning.Transform;
import org.apache.commons.math4.util.FastMath;

public class PolyhedronsSet
extends AbstractRegion<Euclidean3D, Euclidean2D> {
    public PolyhedronsSet(double tolerance) {
        super(tolerance);
    }

    public PolyhedronsSet(BSPTree<Euclidean3D> tree, double tolerance) {
        super(tree, tolerance);
    }

    public PolyhedronsSet(Collection<SubHyperplane<Euclidean3D>> boundary, double tolerance) {
        super(boundary, tolerance);
    }

    public PolyhedronsSet(List<Cartesian3D> vertices, List<int[]> facets, double tolerance) {
        super(PolyhedronsSet.buildBoundary(vertices, facets, tolerance), tolerance);
    }

    public PolyhedronsSet(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, double tolerance) {
        super(PolyhedronsSet.buildBoundary(xMin, xMax, yMin, yMax, zMin, zMax, tolerance), tolerance);
    }

    private static BSPTree<Euclidean3D> buildBoundary(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, double tolerance) {
        if (xMin >= xMax - tolerance || yMin >= yMax - tolerance || zMin >= zMax - tolerance) {
            return new BSPTree<Euclidean3D>(Boolean.FALSE);
        }
        Plane pxMin = new Plane(new Cartesian3D(xMin, 0.0, 0.0), Cartesian3D.MINUS_I, tolerance);
        Plane pxMax = new Plane(new Cartesian3D(xMax, 0.0, 0.0), Cartesian3D.PLUS_I, tolerance);
        Plane pyMin = new Plane(new Cartesian3D(0.0, yMin, 0.0), Cartesian3D.MINUS_J, tolerance);
        Plane pyMax = new Plane(new Cartesian3D(0.0, yMax, 0.0), Cartesian3D.PLUS_J, tolerance);
        Plane pzMin = new Plane(new Cartesian3D(0.0, 0.0, zMin), Cartesian3D.MINUS_K, tolerance);
        Plane pzMax = new Plane(new Cartesian3D(0.0, 0.0, zMax), Cartesian3D.PLUS_K, tolerance);
        Region boundary = new RegionFactory().buildConvex(pxMin, pxMax, pyMin, pyMax, pzMin, pzMax);
        return boundary.getTree(false);
    }

    private static List<SubHyperplane<Euclidean3D>> buildBoundary(List<Cartesian3D> vertices, List<int[]> facets, double tolerance) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            Cartesian3D vi = vertices.get(i);
            for (int j = i + 1; j < vertices.size(); ++j) {
                if (!(Cartesian3D.distance(vi, vertices.get(j)) <= tolerance)) continue;
                throw new MathIllegalArgumentException(LocalizedFormats.CLOSE_VERTICES, vi.getX(), vi.getY(), vi.getZ());
            }
        }
        int[][] references = PolyhedronsSet.findReferences(vertices, facets);
        int[][] successors = PolyhedronsSet.successors(vertices, facets, references);
        for (int vA = 0; vA < vertices.size(); ++vA) {
            for (int vB : successors[vA]) {
                if (vB < 0) continue;
                boolean found = false;
                for (int v : successors[vB]) {
                    found = found || v == vA;
                }
                if (found) continue;
                Cartesian3D start = vertices.get(vA);
                Cartesian3D end = vertices.get(vB);
                throw new MathIllegalArgumentException(LocalizedFormats.EDGE_CONNECTED_TO_ONE_FACET, start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
            }
        }
        ArrayList<SubHyperplane<Euclidean3D>> boundary = new ArrayList<SubHyperplane<Euclidean3D>>();
        Object object = facets.iterator();
        while (object.hasNext()) {
            int[] facet = (int[])object.next();
            Plane plane = new Plane(vertices.get(facet[0]), vertices.get(facet[1]), vertices.get(facet[2]), tolerance);
            Cartesian2D[] two2Points = new Cartesian2D[facet.length];
            for (int i = 0; i < facet.length; ++i) {
                Cartesian3D v = vertices.get(facet[i]);
                if (!plane.contains(v)) {
                    throw new MathIllegalArgumentException(LocalizedFormats.OUT_OF_PLANE, v.getX(), v.getY(), v.getZ());
                }
                two2Points[i] = plane.toSubSpace(v);
            }
            boundary.add(new SubPlane(plane, new PolygonsSet(tolerance, two2Points)));
        }
        return boundary;
    }

    /*
     * WARNING - void declaration
     */
    private static int[][] findReferences(List<Cartesian3D> vertices, List<int[]> facets) {
        void var5_8;
        int[][] references;
        int[] nbFacets = new int[vertices.size()];
        int maxFacets = 0;
        for (int[] nArray : facets) {
            if (nArray.length < 3) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.WRONG_NUMBER_OF_POINTS, (Number)3, nArray.length, true);
            }
            int[] nArray2 = nArray;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                int index;
                int n2 = index = nArray2[i];
                int n3 = nbFacets[n2] + 1;
                nbFacets[n2] = n3;
                maxFacets = FastMath.max(maxFacets, n3);
            }
        }
        for (int[] r : references = new int[vertices.size()][maxFacets]) {
            Arrays.fill(r, -1);
        }
        boolean bl = false;
        while (var5_8 < facets.size()) {
            for (int v : facets.get((int)var5_8)) {
                for (int k = 0; k < maxFacets && references[v][k] >= 0; ++k) {
                }
                references[v][k] = var5_8;
            }
            ++var5_8;
        }
        return references;
    }

    private static int[][] successors(List<Cartesian3D> vertices, List<int[]> facets, int[][] references) {
        int[][] successors;
        for (int[] s : successors = new int[vertices.size()][references[0].length]) {
            Arrays.fill(s, -1);
        }
        for (int v = 0; v < vertices.size(); ++v) {
            for (int k = 0; k < successors[v].length && references[v][k] >= 0; ++k) {
                int i;
                int[] facet = facets.get(references[v][k]);
                for (i = 0; i < facet.length && facet[i] != v; ++i) {
                }
                successors[v][k] = facet[(i + 1) % facet.length];
                for (int l = 0; l < k; ++l) {
                    if (successors[v][l] != successors[v][k]) continue;
                    Cartesian3D start = vertices.get(v);
                    Cartesian3D end = vertices.get(successors[v][k]);
                    throw new MathIllegalArgumentException(LocalizedFormats.FACET_ORIENTATION_MISMATCH, start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ());
                }
            }
        }
        return successors;
    }

    public PolyhedronsSet buildNew(BSPTree<Euclidean3D> tree) {
        return new PolyhedronsSet(tree, this.getTolerance());
    }

    @Override
    protected void computeGeometricalProperties() {
        if (this.isEmpty()) {
            this.setSize(0.0);
            this.setBarycenter(Cartesian3D.NaN);
        } else if (this.isFull()) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Cartesian3D.NaN);
        } else {
            FacetsContributionVisitor contributionVisitor = new FacetsContributionVisitor();
            this.getTree(true).visit(contributionVisitor);
            double size = contributionVisitor.getSize();
            Cartesian3D barycenter = contributionVisitor.getBarycenter();
            if (size < 0.0) {
                this.setSize(Double.POSITIVE_INFINITY);
                this.setBarycenter(Cartesian3D.NaN);
            } else {
                this.setSize(size);
                this.setBarycenter(barycenter);
            }
        }
    }

    public SubHyperplane<Euclidean3D> firstIntersection(Cartesian3D point, Line line) {
        return this.recurseFirstIntersection(this.getTree(true), point, line);
    }

    private SubHyperplane<Euclidean3D> recurseFirstIntersection(BSPTree<Euclidean3D> node, Cartesian3D point, Line line) {
        SubHyperplane<Euclidean3D> facet;
        Cartesian3D hit3D;
        SubHyperplane<Euclidean3D> facet2;
        BSPTree<Euclidean3D> far;
        BSPTree<Euclidean3D> near;
        boolean in;
        SubHyperplane<Euclidean3D> cut = node.getCut();
        if (cut == null) {
            return null;
        }
        BSPTree<Euclidean3D> minus = node.getMinus();
        BSPTree<Euclidean3D> plus = node.getPlus();
        Plane plane = (Plane)cut.getHyperplane();
        double offset = plane.getOffset(point);
        boolean bl = in = FastMath.abs(offset) < this.getTolerance();
        if (offset < 0.0) {
            near = minus;
            far = plus;
        } else {
            near = plus;
            far = minus;
        }
        if (in && (facet2 = this.boundaryFacet(point, node)) != null) {
            return facet2;
        }
        SubHyperplane<Euclidean3D> crossed = this.recurseFirstIntersection(near, point, line);
        if (crossed != null) {
            return crossed;
        }
        if (!in && (hit3D = plane.intersection(line)) != null && line.getAbscissa(hit3D) > line.getAbscissa(point) && (facet = this.boundaryFacet(hit3D, node)) != null) {
            return facet;
        }
        return this.recurseFirstIntersection(far, point, line);
    }

    private SubHyperplane<Euclidean3D> boundaryFacet(Cartesian3D point, BSPTree<Euclidean3D> node) {
        Cartesian2D point2D = ((Plane)node.getCut().getHyperplane()).toSubSpace(point);
        BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
        if (attribute.getPlusOutside() != null && ((SubPlane)attribute.getPlusOutside()).getRemainingRegion().checkPoint(point2D) == Region.Location.INSIDE) {
            return attribute.getPlusOutside();
        }
        if (attribute.getPlusInside() != null && ((SubPlane)attribute.getPlusInside()).getRemainingRegion().checkPoint(point2D) == Region.Location.INSIDE) {
            return attribute.getPlusInside();
        }
        return null;
    }

    public PolyhedronsSet rotate(Cartesian3D center, Rotation rotation) {
        return (PolyhedronsSet)this.applyTransform(new RotationTransform(center, rotation));
    }

    public PolyhedronsSet translate(Cartesian3D translation) {
        return (PolyhedronsSet)this.applyTransform(new TranslationTransform(translation));
    }

    private static class TranslationTransform
    implements Transform<Euclidean3D, Euclidean2D> {
        private final Cartesian3D translation;
        private Plane cachedOriginal;
        private Transform<Euclidean2D, Euclidean1D> cachedTransform;

        TranslationTransform(Cartesian3D translation) {
            this.translation = translation;
        }

        public Cartesian3D apply(Point<Euclidean3D> point) {
            return new Cartesian3D(1.0, (Cartesian3D)point, 1.0, this.translation);
        }

        public Plane apply(Hyperplane<Euclidean3D> hyperplane) {
            return ((Plane)hyperplane).translate(this.translation);
        }

        @Override
        public SubHyperplane<Euclidean2D> apply(SubHyperplane<Euclidean2D> sub, Hyperplane<Euclidean3D> original, Hyperplane<Euclidean3D> transformed) {
            if (original != this.cachedOriginal) {
                Plane oPlane = (Plane)original;
                Plane tPlane = (Plane)transformed;
                Cartesian2D shift = tPlane.toSubSpace((Cartesian3D)this.apply((Point)oPlane.getOrigin()));
                this.cachedOriginal = (Plane)original;
                this.cachedTransform = org.apache.commons.math4.geometry.euclidean.twod.Line.getTransform(1.0, 0.0, 0.0, 1.0, shift.getX(), shift.getY());
            }
            return ((SubLine)sub).applyTransform(this.cachedTransform);
        }
    }

    private static class RotationTransform
    implements Transform<Euclidean3D, Euclidean2D> {
        private final Cartesian3D center;
        private final Rotation rotation;
        private Plane cachedOriginal;
        private Transform<Euclidean2D, Euclidean1D> cachedTransform;

        RotationTransform(Cartesian3D center, Rotation rotation) {
            this.center = center;
            this.rotation = rotation;
        }

        public Cartesian3D apply(Point<Euclidean3D> point) {
            Vector delta = ((Cartesian3D)point).subtract((Vector)this.center);
            return new Cartesian3D(1.0, this.center, 1.0, this.rotation.applyTo((Cartesian3D)delta));
        }

        public Plane apply(Hyperplane<Euclidean3D> hyperplane) {
            return ((Plane)hyperplane).rotate(this.center, this.rotation);
        }

        @Override
        public SubHyperplane<Euclidean2D> apply(SubHyperplane<Euclidean2D> sub, Hyperplane<Euclidean3D> original, Hyperplane<Euclidean3D> transformed) {
            if (original != this.cachedOriginal) {
                Plane oPlane = (Plane)original;
                Plane tPlane = (Plane)transformed;
                Cartesian3D p00 = oPlane.getOrigin();
                Cartesian3D p10 = oPlane.toSpace(new Cartesian2D(1.0, 0.0));
                Cartesian3D p01 = oPlane.toSpace(new Cartesian2D(0.0, 1.0));
                Cartesian2D tP00 = tPlane.toSubSpace((Cartesian3D)this.apply((Point)p00));
                Cartesian2D tP10 = tPlane.toSubSpace((Cartesian3D)this.apply((Point)p10));
                Cartesian2D tP01 = tPlane.toSubSpace((Cartesian3D)this.apply((Point)p01));
                this.cachedOriginal = (Plane)original;
                this.cachedTransform = org.apache.commons.math4.geometry.euclidean.twod.Line.getTransform(tP10.getX() - tP00.getX(), tP10.getY() - tP00.getY(), tP01.getX() - tP00.getX(), tP01.getY() - tP00.getY(), tP00.getX(), tP00.getY());
            }
            return ((SubLine)sub).applyTransform(this.cachedTransform);
        }
    }

    private static class FacetsContributionVisitor
    implements BSPTreeVisitor<Euclidean3D> {
        private double volumeSum;
        private Cartesian3D barycenterSum = Cartesian3D.ZERO;

        private FacetsContributionVisitor() {
        }

        public double getSize() {
            return this.volumeSum / 3.0;
        }

        public Cartesian3D getBarycenter() {
            return new Cartesian3D(1.0 / (4.0 * this.getSize()), this.barycenterSum);
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean3D> node) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }

        @Override
        public void visitInternalNode(BSPTree<Euclidean3D> node) {
            BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
            if (attribute.getPlusOutside() != null) {
                this.addContribution(attribute.getPlusOutside(), false);
            }
            if (attribute.getPlusInside() != null) {
                this.addContribution(attribute.getPlusInside(), true);
            }
        }

        @Override
        public void visitLeafNode(BSPTree<Euclidean3D> node) {
        }

        private void addContribution(SubHyperplane<Euclidean3D> facet, boolean reversed) {
            Region polygon = ((SubPlane)facet).getRemainingRegion();
            double area = polygon.getSize();
            if (Double.isInfinite(area)) {
                this.volumeSum = Double.POSITIVE_INFINITY;
                this.barycenterSum = Cartesian3D.NaN;
            } else {
                Plane plane = (Plane)facet.getHyperplane();
                Point facetBarycenter = plane.toSpace(polygon.getBarycenter());
                double scaledVolume = area * ((Cartesian3D)facetBarycenter).dotProduct(plane.getNormal());
                if (reversed) {
                    scaledVolume = -scaledVolume;
                }
                this.volumeSum += scaledVolume;
                this.barycenterSum = new Cartesian3D(1.0, this.barycenterSum, scaledVolume, (Cartesian3D)facetBarycenter);
            }
        }
    }
}

