/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.BaseProvider;
import org.apache.commons.rng.core.source32.RandomIntSource;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class IntProvider
extends BaseProvider
implements RandomIntSource {
    @Override
    public abstract int next();

    @Override
    public int nextInt() {
        return this.next();
    }

    @Override
    public boolean nextBoolean() {
        return NumberFactory.makeBoolean(this.nextInt());
    }

    @Override
    public double nextDouble() {
        return NumberFactory.makeDouble(this.nextInt(), this.nextInt());
    }

    @Override
    public float nextFloat() {
        return NumberFactory.makeFloat(this.nextInt());
    }

    @Override
    public long nextLong() {
        return NumberFactory.makeLong(this.nextInt(), this.nextInt());
    }

    @Override
    public void nextBytes(byte[] bytes) {
        IntProvider.nextBytesFill(this, bytes, 0, bytes.length);
    }

    @Override
    public void nextBytes(byte[] bytes, int start, int len) {
        this.checkIndex(0, bytes.length - 1, start);
        this.checkIndex(0, bytes.length - start, len);
        IntProvider.nextBytesFill(this, bytes, start, len);
    }

    static void nextBytesFill(RandomIntSource source, byte[] bytes, int start, int len) {
        int index = start;
        int indexLoopLimit = index + (len & 0x7FFFFFFC);
        while (index < indexLoopLimit) {
            int random = source.next();
            bytes[index++] = (byte)random;
            bytes[index++] = (byte)(random >>> 8);
            bytes[index++] = (byte)(random >>> 16);
            bytes[index++] = (byte)(random >>> 24);
        }
        int indexLimit = start + len;
        if (index < indexLimit) {
            int random = source.next();
            while (true) {
                bytes[index++] = (byte)random;
                if (index >= indexLimit) break;
                random >>>= 8;
            }
        }
    }
}

