/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.int_double;

import io.virtdata.continuous.common.InterpolatingIntDoubleSampler;
import io.virtdata.continuous.common.RealDistributionICDSource;
import io.virtdata.continuous.common.RealIntDoubleSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.IntToDoubleFunction;
import org.apache.commons.statistics.distribution.ContinuousDistribution;

public class IntToDoubleContinuousCurve
implements IntToDoubleFunction {
    private ContinuousDistribution distribution;
    private IntToDoubleFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(IntToDoubleContinuousCurve.COMPUTE);
            this.add(IntToDoubleContinuousCurve.INTERPOLATE);
            this.add(IntToDoubleContinuousCurve.MAP);
            this.add(IntToDoubleContinuousCurve.HASH);
        }
    };

    public IntToDoubleContinuousCurve(ContinuousDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        RealDistributionICDSource icdSource = new RealDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        this.function = interpolate ? new InterpolatingIntDoubleSampler(icdSource, 1000, hash) : new RealIntDoubleSampler(icdSource, hash);
    }

    @Override
    public double applyAsDouble(int value) {
        return this.function.applyAsDouble(value);
    }
}

