/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.int_double;

import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class)
public class UniformAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "Uniform";
    }

    @Override
    public String getPackageName() {
        return "io.virtdata.continuous.int_double";
    }

    @Override
    public String getClassJavadoc() {
        return "@see <a href=\"https://en.wikipedia.org/wiki/Uniform_distribution_(continuous)\">Wikipedia: Uniform distribution (continuous)</a>\n@see <a href=\"https://commons.apache.org/proper/commons-statistics/commons-statistics-distribution/apidocs/org/apache/commons/statistics/distribution/UniformContinuousDistribution.html\">Commons JavaDoc: UniformContinuousDistribution</a>\n\n Generate samples according to the specified probability density.\n\n The input value consists of a long between 0L and Long.MAX_VALUE.\n This value is scaled to the unit interval (0.0, 1.0) as\n an index into a sampling function. The method used is\n inverse cumulative density sampling.\n\n <H3>Sampling Mode</H3>\n\n The curve can be sampled in either map or hash mode. Map mode\n simply indexes into the probability curve in the order that\n it would appear on a density plot. Hash mode applies a\n murmur3 hash to the input value before scaling from the\n range of longs to the unit interval, thus providing a pseudo-random\n sample of a value from the curve. This is usually what you want,\n so hash mode is the default.  To enable map mode, simply provide\n \"map\" as one of the modifiers as explained below.\n\n <H3>Interpolation</H3>\n\n The curve can be computed from the sampling function for each value\n generated, or it can be provided via interpolation with a lookup table.\n Using interpolation makes all the generator functions perform the\n same. This is almost always what you want, so interpolation is\n enabled by default. In order to compute the value for every sample\n instead, simply provide \"compute\" as one of the modifiers as explained\n below.\n\n You can add optional modifiers after the distribution parameters.\n You can add one of 'hash' or 'map' but not both. If neither of these is\n added, 'hash' is implied as a default.\n You can add one of 'interpolate' or 'compute' but not both. If neither\n of these is added, 'interpolate' is implied as a default.\n\n At times, it might be useful to add 'hash', 'interpolate' to your\n specifiers as a form of verbosity or explicit specification.\n\n";
    }

    @Override
    public String getInType() {
        return "int";
    }

    @Override
    public String getOutType() {
        return "double";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.distributions};
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("Uniform", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("lower", "double");
                        this.put("upper", "double");
                        this.put("mods", "java.lang.String[]...");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){}));
            }
        };
    }
}

