/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class BoxMullerNormalizedGaussianSampler
extends SamplerBase
implements NormalizedGaussianSampler {
    private double nextGaussian = Double.NaN;

    public BoxMullerNormalizedGaussianSampler(UniformRandomProvider rng) {
        super(rng);
    }

    @Override
    public double sample() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x;
            double r = Math.sqrt(-2.0 * Math.log(y));
            random = r * Math.cos(alpha);
            this.nextGaussian = r * Math.sin(alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    @Override
    public String toString() {
        return "Box-Muller normalized Gaussian deviate [" + super.toString() + "]";
    }
}

