/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFunc;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import io.virtdata.processors.FuncEnumerator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public class FunctionDocInfoWriter
implements FuncEnumerator.Listener {
    private final String suffix;
    private Filer filer;
    private Messager messenger;

    public FunctionDocInfoWriter(Filer filer, Messager messenger, String suffix) {
        this.filer = filer;
        this.messenger = messenger;
        this.suffix = suffix;
    }

    @Override
    public void onFunctionModel(DocForFunc functionDoc) {
        TypeSpec typeSpec = this.createInlineClassForDocFuncData(functionDoc, functionDoc.getClassName() + this.suffix);
        JavaFile javafile = JavaFile.builder(functionDoc.getPackageName(), typeSpec).addFileComment("This file is auto-generated.", new Object[0]).build();
        try {
            javafile.writeTo(this.filer);
        }
        catch (IOException e) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Error writing javafile " + javafile.packageName + "." + javafile.typeSpec.toString());
            throw new RuntimeException(e);
        }
    }

    private TypeSpec createInlineClassForDocFuncData(DocForFunc doc, String newClassName) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        MethodSpec getClassName = MethodSpec.methodBuilder("getClassName").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", doc.getClassName()).build();
        methods.add(getClassName);
        MethodSpec getPackageName = MethodSpec.methodBuilder("getPackageName").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", doc.getPackageName()).build();
        methods.add(getPackageName);
        MethodSpec getClassJavaDoc = MethodSpec.methodBuilder("getClassJavadoc").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", doc.getClassJavadoc()).build();
        methods.add(getClassJavaDoc);
        MethodSpec getInType = MethodSpec.methodBuilder("getInType").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", doc.getInType()).build();
        methods.add(getInType);
        MethodSpec getOutType = MethodSpec.methodBuilder("getOutType").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", doc.getOutType()).build();
        methods.add(getOutType);
        CodeBlock ctorsHead = CodeBlock.builder().add("return new $T<$T>() {{$>\n", ArrayList.class, DocCtorData.class).build();
        CodeBlock ctorsTail = CodeBlock.builder().add("$<}}", new Object[0]).build();
        CodeBlock.Builder ctors = CodeBlock.builder().add(ctorsHead);
        for (DocCtorData ctor : doc.getCtors()) {
            ctors.add("add(new $T($S, $S, \n$>new $T<String, String>() {{\n$>", DocForFuncCtor.class, ctor.getClassName(), ctor.getCtorJavaDoc(), LinkedHashMap.class);
            for (Map.Entry<String, String> entry : ctor.getArgs().entrySet()) {
                ctors.add("put($S,$S);\n", entry.getKey(), entry.getValue());
            }
            ctors.add("$<}},\n", new Object[0]);
            ctors.add("new $T<$T<$T>>() {{\n$>", ArrayList.class, List.class, String.class);
            for (List list : ctor.getExamples()) {
                ctors.add("add(new $T<$T>() {{$>\n", ArrayList.class, String.class);
                for (String s : list) {
                    ctors.add("add(\"" + s + "\");\n", new Object[0]);
                }
                ctors.add("$<}});\n", new Object[0]);
            }
            ctors.add("$<}}", new Object[0]);
            ctors.add("\n$<));\n", new Object[0]);
        }
        ctors.add(ctorsTail);
        MethodSpec getCategoriesMethod = MethodSpec.methodBuilder("getCategories").addModifiers(Modifier.PUBLIC).returns(ArrayTypeName.of(Category.class)).addStatement("return new $T[] { " + Arrays.stream(doc.getCategories()).map(c -> "Category." + (Object)c).collect(Collectors.joining(",")) + " }", Category.class).build();
        methods.add(getCategoriesMethod);
        MethodSpec getCtorsMethod = MethodSpec.methodBuilder("getCtors").addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(List.class, new Type[]{DocCtorData.class})).addStatement(ctors.build()).build();
        methods.add(getCtorsMethod);
        AnnotationSpec serviceAnnotation = AnnotationSpec.builder(Service.class).addMember("value", "$T.class", DocFuncData.class).build();
        TypeSpec typeSpec = TypeSpec.classBuilder(newClassName).addAnnotation(serviceAnnotation).addModifiers(Modifier.PUBLIC).addMethods(methods).addSuperinterface((Type)((Object)DocFuncData.class)).build();
        return typeSpec;
    }
}

