/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration;

import org.apache.commons.math4.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math4.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.util.FastMath;

public class SimpsonIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int SIMPSON_MAX_ITERATIONS_COUNT = 63;

    public SimpsonIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 63) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)63, false);
        }
    }

    public SimpsonIntegrator(int minimalIterationCount, int maximalIterationCount) throws NotStrictlyPositiveException, NumberIsTooSmallException, NumberIsTooLargeException {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 63) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)63, false);
        }
    }

    public SimpsonIntegrator() {
        super(3, 63);
    }

    @Override
    protected double doIntegrate() {
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        double s0 = qtrap.stage(this, 0);
        double oldt = qtrap.stage(this, 1);
        double olds = (4.0 * oldt - s0) / 3.0;
        while (true) {
            double rLimit;
            double delta;
            this.iterations.incrementCount();
            int i = this.getIterations();
            double t = qtrap.stage(this, i + 1);
            double s = (4.0 * t - oldt) / 3.0;
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs(s - olds)) <= (rLimit = this.getRelativeAccuracy() * (FastMath.abs(olds) + FastMath.abs(s)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return s;
            }
            olds = s;
            oldt = t;
        }
    }
}

