/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class LogNormalSampler
implements ContinuousSampler {
    private final double scale;
    private final double shape;
    private final NormalizedGaussianSampler gaussian;

    public LogNormalSampler(NormalizedGaussianSampler gaussian, double scale, double shape) {
        this.scale = scale;
        this.shape = shape;
        this.gaussian = gaussian;
    }

    @Override
    public double sample() {
        return Math.exp(this.scale + this.shape * this.gaussian.sample());
    }

    public String toString() {
        return "Log-normal deviate [" + this.gaussian.toString() + "]";
    }
}

