/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.complex;

import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.IntegerSequence;
import org.apache.commons.numbers.complex.Complex;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex polar2Complex(double r, double theta) throws MathIllegalArgumentException {
        if (r < 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_COMPLEX_MODULE, r);
        }
        return Complex.ofCartesian(r * FastMath.cos(theta), r * FastMath.sin(theta));
    }

    public static Complex[] polar2Complex(double[] r, double[] theta) throws MathIllegalArgumentException {
        int length = r.length;
        Complex[] c = new Complex[length];
        for (int x = 0; x < length; ++x) {
            if (r[x] < 0.0) {
                throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_COMPLEX_MODULE, r[x]);
            }
            c[x] = Complex.ofCartesian(r[x] * FastMath.cos(theta[x]), r[x] * FastMath.sin(theta[x]));
        }
        return c;
    }

    public static Complex[][] polar2Complex(double[][] r, double[][] theta) throws MathIllegalArgumentException {
        int length = r.length;
        Complex[][] c = new Complex[length][];
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.polar2Complex(r[x], theta[x]);
        }
        return c;
    }

    public static Complex[][][] polar2Complex(double[][][] r, double[][][] theta) throws MathIllegalArgumentException {
        int length = r.length;
        Complex[][][] c = new Complex[length][][];
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.polar2Complex(r[x], theta[x]);
        }
        return c;
    }

    public static Complex extractComplexFromRealArray(double[] real, int index) {
        return Complex.ofReal(real[index]);
    }

    public static Complex extractComplexFromRealArray(float[] real, int index) {
        return Complex.ofReal(real[index]);
    }

    public static Complex extractComplexFromImaginaryArray(double[] imaginary, int index) {
        return Complex.ofCartesian(0.0, imaginary[index]);
    }

    public static Complex extractComplexFromImaginaryArray(float[] imaginary, int index) {
        return Complex.ofCartesian(0.0, imaginary[index]);
    }

    public static double extractRealFromComplexArray(Complex[] complex, int index) {
        return complex[index].getReal();
    }

    public static float extractRealFloatFromComplexArray(Complex[] complex, int index) {
        return (float)complex[index].getReal();
    }

    public static double extractImaginaryFromComplexArray(Complex[] complex, int index) {
        return complex[index].getImaginary();
    }

    public static float extractImaginaryFloatFromComplexArray(Complex[] complex, int index) {
        return (float)complex[index].getImaginary();
    }

    public static Complex extractComplexFromInterleavedArray(double[] d, int index) {
        return Complex.ofCartesian(d[index * 2], d[index * 2 + 1]);
    }

    public static Complex extractComplexFromInterleavedArray(float[] f, int index) {
        return Complex.ofCartesian(f[index * 2], f[index * 2 + 1]);
    }

    public static double[] extractInterleavedFromComplexArray(Complex[] complex, int index) {
        return new double[]{complex[index].getReal(), complex[index].getImaginary()};
    }

    public static float[] extractInterleavedFloatFromComplexArray(Complex[] complex, int index) {
        return new float[]{(float)complex[index].getReal(), (float)complex[index].getImaginary()};
    }

    public static Complex[] real2Complex(double[] real, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromRealArray(real, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] real2Complex(float[] real, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromRealArray(real, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] real2Complex(double[] real, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromRealArray(real, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] real2Complex(float[] real, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromRealArray(real, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] real2Complex(double[] real, IntegerSequence.Range range) {
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromRealArray(real, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] real2Complex(float[] real, IntegerSequence.Range range) {
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromRealArray(real, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] real2Complex(double[] real) {
        int index = 0;
        Complex[] c = new Complex[real.length];
        for (double d : real) {
            c[index] = Complex.ofReal(d);
            ++index;
        }
        return c;
    }

    public static Complex[] real2Complex(float[] real) {
        int index = 0;
        Complex[] c = new Complex[real.length];
        for (float d : real) {
            c[index] = Complex.ofReal(d);
            ++index;
        }
        return c;
    }

    public static Complex[][] real2Complex(double[][] d) {
        int width = d.length;
        Complex[][] c = new Complex[width][];
        for (int n = 0; n < width; ++n) {
            c[n] = ComplexUtils.real2Complex(d[n]);
        }
        return c;
    }

    public static Complex[][][] real2Complex(double[][][] d) {
        int width = d.length;
        Complex[][][] c = new Complex[width][][];
        for (int x = 0; x < width; ++x) {
            c[x] = ComplexUtils.real2Complex(d[x]);
        }
        return c;
    }

    public static double[] complex2Real(Complex[] c, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        double[] d = new double[range.size()];
        for (Integer i : range) {
            d[index] = ComplexUtils.extractRealFromComplexArray(c, i);
            ++index;
        }
        return d;
    }

    public static float[] complex2RealFloat(Complex[] c, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        float[] f = new float[range.size()];
        for (Integer i : range) {
            f[index] = ComplexUtils.extractRealFloatFromComplexArray(c, i);
            ++index;
        }
        return f;
    }

    public static double[] complex2Real(Complex[] c, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        double[] d = new double[range.size()];
        for (Integer i : range) {
            d[index] = ComplexUtils.extractRealFromComplexArray(c, i);
            ++index;
        }
        return d;
    }

    public static float[] complex2RealFloat(Complex[] c, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        float[] f = new float[range.size()];
        for (Integer i : range) {
            f[index] = ComplexUtils.extractRealFloatFromComplexArray(c, i);
            ++index;
        }
        return f;
    }

    public static double[] complex2Real(Complex[] c, IntegerSequence.Range range) {
        int index = 0;
        double[] d = new double[range.size()];
        for (Integer i : range) {
            d[index] = ComplexUtils.extractRealFromComplexArray(c, i);
            ++index;
        }
        return d;
    }

    public static float[] complex2RealFloat(Complex[] c, IntegerSequence.Range range) {
        int index = 0;
        float[] f = new float[range.size()];
        for (Integer i : range) {
            f[index] = ComplexUtils.extractRealFloatFromComplexArray(c, i);
            ++index;
        }
        return f;
    }

    public static double[] complex2Real(Complex[] c) {
        int index = 0;
        double[] d = new double[c.length];
        for (Complex cc : c) {
            d[index] = cc.getReal();
            ++index;
        }
        return d;
    }

    public static float[] complex2RealFloat(Complex[] c) {
        int index = 0;
        float[] f = new float[c.length];
        for (Complex cc : c) {
            f[index] = (float)cc.getReal();
            ++index;
        }
        return f;
    }

    public static double[][] complex2Real(Complex[][] c) {
        int length = c.length;
        double[][] d = new double[length][];
        for (int n = 0; n < length; ++n) {
            d[n] = ComplexUtils.complex2Real(c[n]);
        }
        return d;
    }

    public static float[][] complex2RealFloat(Complex[][] c) {
        int length = c.length;
        float[][] f = new float[length][];
        for (int n = 0; n < length; ++n) {
            f[n] = ComplexUtils.complex2RealFloat(c[n]);
        }
        return f;
    }

    public static double[][][] complex2Real(Complex[][][] c) {
        int length = c.length;
        double[][][] d = new double[length][][];
        for (int n = 0; n < length; ++n) {
            d[n] = ComplexUtils.complex2Real(c[n]);
        }
        return d;
    }

    public static float[][][] complex2RealFloat(Complex[][][] c) {
        int length = c.length;
        float[][][] f = new float[length][][];
        for (int n = 0; n < length; ++n) {
            f[n] = ComplexUtils.complex2RealFloat(c[n]);
        }
        return f;
    }

    public static Complex[] imaginary2Complex(double[] imaginary, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromImaginaryArray(imaginary, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] imaginary2Complex(float[] imaginary, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromImaginaryArray(imaginary, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] imaginary2Complex(double[] imaginary, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromImaginaryArray(imaginary, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] imaginary2Complex(float[] imaginary, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromImaginaryArray(imaginary, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] imaginary2Complex(double[] imaginary, IntegerSequence.Range range) {
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromImaginaryArray(imaginary, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] imaginary2Complex(float[] imaginary, IntegerSequence.Range range) {
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromImaginaryArray(imaginary, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] imaginary2Complex(double[] imaginary) {
        int index = 0;
        Complex[] c = new Complex[imaginary.length];
        for (double d : imaginary) {
            c[index] = Complex.ofCartesian(0.0, d);
            ++index;
        }
        return c;
    }

    public static Complex[] imaginary2Complex(float[] imaginary) {
        int index = 0;
        Complex[] c = new Complex[imaginary.length];
        for (float d : imaginary) {
            c[index] = Complex.ofCartesian(0.0, d);
            ++index;
        }
        return c;
    }

    public static Complex[][] imaginary2Complex(double[][] d) {
        int width = d.length;
        int height = d[0].length;
        Complex[][] c = new Complex[width][height];
        for (int n = 0; n < width; ++n) {
            c[n] = ComplexUtils.imaginary2Complex(d[n]);
        }
        return c;
    }

    public static Complex[][][] imaginary2Complex(double[][][] d) {
        int width = d.length;
        int height = d[0].length;
        int depth = d[0].length;
        Complex[][][] c = new Complex[width][height][depth];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                c[x][y] = ComplexUtils.imaginary2Complex(d[x][y]);
            }
        }
        return c;
    }

    public static double[] complex2Imaginary(Complex[] c, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        double[] d = new double[range.size()];
        for (Integer i : range) {
            d[index] = ComplexUtils.extractImaginaryFromComplexArray(c, i);
            ++index;
        }
        return d;
    }

    public static float[] complex2ImaginaryFloat(Complex[] c, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        float[] f = new float[range.size()];
        for (Integer i : range) {
            f[index] = ComplexUtils.extractImaginaryFloatFromComplexArray(c, i);
            ++index;
        }
        return f;
    }

    public static double[] complex2Imaginary(Complex[] c, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        double[] d = new double[range.size()];
        for (Integer i : range) {
            d[index] = ComplexUtils.extractImaginaryFromComplexArray(c, i);
            ++index;
        }
        return d;
    }

    public static float[] complex2ImaginaryFloat(Complex[] c, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        float[] f = new float[range.size()];
        for (Integer i : range) {
            f[index] = ComplexUtils.extractImaginaryFloatFromComplexArray(c, i);
            ++index;
        }
        return f;
    }

    public static double[] complex2Imaginary(Complex[] c, IntegerSequence.Range range) {
        int index = 0;
        double[] d = new double[range.size()];
        for (Integer i : range) {
            d[index] = ComplexUtils.extractImaginaryFromComplexArray(c, i);
            ++index;
        }
        return d;
    }

    public static float[] complex2ImaginaryFloat(Complex[] c, IntegerSequence.Range range) {
        int index = 0;
        float[] f = new float[range.size()];
        for (Integer i : range) {
            f[index] = ComplexUtils.extractImaginaryFloatFromComplexArray(c, i);
            ++index;
        }
        return f;
    }

    public static double[] complex2Imaginary(Complex[] c) {
        int index = 0;
        double[] d = new double[c.length];
        for (Complex cc : c) {
            d[index] = cc.getImaginary();
            ++index;
        }
        return d;
    }

    public static float[] complex2ImaginaryFloat(Complex[] c) {
        int index = 0;
        float[] f = new float[c.length];
        for (Complex cc : c) {
            f[index] = (float)cc.getImaginary();
            ++index;
        }
        return f;
    }

    public static double[][] complex2Imaginary(Complex[][] c) {
        int length = c.length;
        double[][] d = new double[length][];
        for (int n = 0; n < length; ++n) {
            d[n] = ComplexUtils.complex2Imaginary(c[n]);
        }
        return d;
    }

    public static float[][] complex2ImaginaryFloat(Complex[][] c) {
        int length = c.length;
        float[][] f = new float[length][];
        for (int n = 0; n < length; ++n) {
            f[n] = ComplexUtils.complex2ImaginaryFloat(c[n]);
        }
        return f;
    }

    public static double[][][] complex2Imaginary(Complex[][][] c) {
        int length = c.length;
        double[][][] d = new double[length][][];
        for (int n = 0; n < length; ++n) {
            d[n] = ComplexUtils.complex2Imaginary(c[n]);
        }
        return d;
    }

    public static float[][][] complex2ImaginaryFloat(Complex[][][] c) {
        int length = c.length;
        float[][][] f = new float[length][][];
        for (int n = 0; n < length; ++n) {
            f[n] = ComplexUtils.complex2ImaginaryFloat(c[n]);
        }
        return f;
    }

    public static Complex[] interleaved2Complex(double[] interleaved, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromInterleavedArray(interleaved, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] interleaved2Complex(float[] interleaved, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromInterleavedArray(interleaved, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] interleaved2Complex(double[] interleaved, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromInterleavedArray(interleaved, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] interleaved2Complex(float[] interleaved, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromInterleavedArray(interleaved, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] interleaved2Complex(double[] interleaved, IntegerSequence.Range range) {
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromInterleavedArray(interleaved, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] interleaved2Complex(float[] interleaved, IntegerSequence.Range range) {
        int index = 0;
        Complex[] c = new Complex[range.size()];
        for (Integer i : range) {
            c[index] = ComplexUtils.extractComplexFromInterleavedArray(interleaved, (int)i);
            ++index;
        }
        return c;
    }

    public static Complex[] interleaved2Complex(double[] interleaved) {
        int length = interleaved.length / 2;
        Complex[] c = new Complex[length];
        for (int n = 0; n < length; ++n) {
            c[n] = Complex.ofCartesian(interleaved[n * 2], interleaved[n * 2 + 1]);
        }
        return c;
    }

    public static Complex[] interleaved2Complex(float[] interleaved) {
        int length = interleaved.length / 2;
        Complex[] c = new Complex[length];
        for (int n = 0; n < length; ++n) {
            c[n] = Complex.ofCartesian(interleaved[n * 2], interleaved[n * 2 + 1]);
        }
        return c;
    }

    public static double[] complex2Interleaved(Complex[] c, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        double[] d = new double[range.size() * 2];
        for (Integer i : range) {
            int real = index * 2;
            int imag = index * 2 + 1;
            d[real] = c[i].getReal();
            d[imag] = c[i].getImaginary();
            ++index;
        }
        return d;
    }

    public static float[] complex2InterleavedFloat(Complex[] c, int start, int end) {
        IntegerSequence.Range range = IntegerSequence.range(start, end);
        int index = 0;
        float[] f = new float[range.size() * 2];
        for (Integer i : range) {
            int real = index * 2;
            int imag = index * 2 + 1;
            f[real] = (float)c[i].getReal();
            f[imag] = (float)c[i].getImaginary();
            ++index;
        }
        return f;
    }

    public static double[] complex2Interleaved(Complex[] c, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        double[] d = new double[range.size() * 2];
        for (Integer i : range) {
            int real = index * 2;
            int imag = index * 2 + 1;
            d[real] = c[i].getReal();
            d[imag] = c[i].getImaginary();
            ++index;
        }
        return d;
    }

    public static float[] complex2InterleavedFloat(Complex[] c, int start, int end, int increment) {
        IntegerSequence.Range range = IntegerSequence.range(start, end, increment);
        int index = 0;
        float[] f = new float[range.size() * 2];
        for (Integer i : range) {
            int real = index * 2;
            int imag = index * 2 + 1;
            f[real] = (float)c[i].getReal();
            f[imag] = (float)c[i].getImaginary();
            ++index;
        }
        return f;
    }

    public static double[] complex2Interleaved(Complex[] c, IntegerSequence.Range range) {
        int index = 0;
        double[] d = new double[range.size() * 2];
        for (Integer i : range) {
            int real = index * 2;
            int imag = index * 2 + 1;
            d[real] = c[i].getReal();
            d[imag] = c[i].getImaginary();
            ++index;
        }
        return d;
    }

    public static float[] complex2InterleavedFloat(Complex[] c, IntegerSequence.Range range) {
        int index = 0;
        float[] f = new float[range.size() * 2];
        for (Integer i : range) {
            int real = index * 2;
            int imag = index * 2 + 1;
            f[real] = (float)c[i].getReal();
            f[imag] = (float)c[i].getImaginary();
            ++index;
        }
        return f;
    }

    public static double[] complex2Interleaved(Complex[] c) {
        int index = 0;
        double[] d = new double[c.length * 2];
        for (Complex cc : c) {
            int real = index * 2;
            int imag = index * 2 + 1;
            d[real] = cc.getReal();
            d[imag] = cc.getImaginary();
            ++index;
        }
        return d;
    }

    public static float[] complex2InterleavedFloat(Complex[] c) {
        int index = 0;
        float[] f = new float[c.length * 2];
        for (Complex cc : c) {
            int real = index * 2;
            int imag = index * 2 + 1;
            f[real] = (float)cc.getReal();
            f[imag] = (float)cc.getImaginary();
            ++index;
        }
        return f;
    }

    public static double[][] complex2Interleaved(Complex[][] c, int interleavedDim) {
        double[][] d;
        if (interleavedDim > 1 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 1);
        }
        int width = c.length;
        int height = c[0].length;
        if (interleavedDim == 0) {
            d = new double[2 * width][height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    d[x * 2][y] = c[x][y].getReal();
                    d[x * 2 + 1][y] = c[x][y].getImaginary();
                }
            }
        } else {
            d = new double[width][2 * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    d[x][y * 2] = c[x][y].getReal();
                    d[x][y * 2 + 1] = c[x][y].getImaginary();
                }
            }
        }
        return d;
    }

    public static double[][] complex2Interleaved(Complex[][] c) {
        return ComplexUtils.complex2Interleaved(c, 1);
    }

    public static double[][][] complex2Interleaved(Complex[][][] c, int interleavedDim) {
        double[][][] d;
        if (interleavedDim > 2 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 2);
        }
        int width = c.length;
        int height = c[0].length;
        int depth = c[0][0].length;
        if (interleavedDim == 0) {
            d = new double[2 * width][height][depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        d[x * 2][y][z] = c[x][y][z].getReal();
                        d[x * 2 + 1][y][z] = c[x][y][z].getImaginary();
                    }
                }
            }
        } else if (interleavedDim == 1) {
            d = new double[width][2 * height][depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        d[x][y * 2][z] = c[x][y][z].getReal();
                        d[x][y * 2 + 1][z] = c[x][y][z].getImaginary();
                    }
                }
            }
        } else {
            d = new double[width][height][2 * depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        d[x][y][z * 2] = c[x][y][z].getReal();
                        d[x][y][z * 2 + 1] = c[x][y][z].getImaginary();
                    }
                }
            }
        }
        return d;
    }

    public static double[][][] complex2Interleaved(Complex[][][] c) {
        return ComplexUtils.complex2Interleaved(c, 2);
    }

    public static float[][] complex2InterleavedFloat(Complex[][] c, int interleavedDim) {
        float[][] d;
        if (interleavedDim > 1 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 1);
        }
        int width = c.length;
        int height = c[0].length;
        if (interleavedDim == 0) {
            d = new float[2 * width][height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    d[x * 2][y] = (float)c[x][y].getReal();
                    d[x * 2 + 1][y] = (float)c[x][y].getImaginary();
                }
            }
        } else {
            d = new float[width][2 * height];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    d[x][y * 2] = (float)c[x][y].getReal();
                    d[x][y * 2 + 1] = (float)c[x][y].getImaginary();
                }
            }
        }
        return d;
    }

    public static float[][] complex2InterleavedFloat(Complex[][] c) {
        return ComplexUtils.complex2InterleavedFloat(c, 1);
    }

    public static float[][][] complex2InterleavedFloat(Complex[][][] c, int interleavedDim) {
        float[][][] d;
        if (interleavedDim > 2 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 2);
        }
        int width = c.length;
        int height = c[0].length;
        int depth = c[0][0].length;
        if (interleavedDim == 0) {
            d = new float[2 * width][height][depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        d[x * 2][y][z] = (float)c[x][y][z].getReal();
                        d[x * 2 + 1][y][z] = (float)c[x][y][z].getImaginary();
                    }
                }
            }
        } else if (interleavedDim == 1) {
            d = new float[width][2 * height][depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        d[x][y * 2][z] = (float)c[x][y][z].getReal();
                        d[x][y * 2 + 1][z] = (float)c[x][y][z].getImaginary();
                    }
                }
            }
        } else {
            d = new float[width][height][2 * depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        d[x][y][z * 2] = (float)c[x][y][z].getReal();
                        d[x][y][z * 2 + 1] = (float)c[x][y][z].getImaginary();
                    }
                }
            }
        }
        return d;
    }

    public static float[][][] complex2InterleavedFloat(Complex[][][] c) {
        return ComplexUtils.complex2InterleavedFloat(c, 2);
    }

    public static Complex[][] interleaved2Complex(double[][] d, int interleavedDim) {
        Complex[][] c;
        if (interleavedDim > 1 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 1);
        }
        int width = d.length;
        int height = d[0].length;
        if (interleavedDim == 0) {
            c = new Complex[width / 2][height];
            for (int x = 0; x < width / 2; ++x) {
                for (int y = 0; y < height; ++y) {
                    c[x][y] = Complex.ofCartesian(d[x * 2][y], d[x * 2 + 1][y]);
                }
            }
        } else {
            c = new Complex[width][height / 2];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height / 2; ++y) {
                    c[x][y] = Complex.ofCartesian(d[x][y * 2], d[x][y * 2 + 1]);
                }
            }
        }
        return c;
    }

    public static Complex[][] interleaved2Complex(double[][] d) {
        return ComplexUtils.interleaved2Complex(d, 1);
    }

    public static Complex[][][] interleaved2Complex(double[][][] d, int interleavedDim) {
        Complex[][][] c;
        if (interleavedDim > 2 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 2);
        }
        int width = d.length;
        int height = d[0].length;
        int depth = d[0][0].length;
        if (interleavedDim == 0) {
            c = new Complex[width / 2][height][depth];
            for (int x = 0; x < width / 2; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        c[x][y][z] = Complex.ofCartesian(d[x * 2][y][z], d[x * 2 + 1][y][z]);
                    }
                }
            }
        } else if (interleavedDim == 1) {
            c = new Complex[width][height / 2][depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height / 2; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        c[x][y][z] = Complex.ofCartesian(d[x][y * 2][z], d[x][y * 2 + 1][z]);
                    }
                }
            }
        } else {
            c = new Complex[width][height][depth / 2];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth / 2; ++z) {
                        c[x][y][z] = Complex.ofCartesian(d[x][y][z * 2], d[x][y][z * 2 + 1]);
                    }
                }
            }
        }
        return c;
    }

    public static Complex[][][] interleaved2Complex(double[][][] d) {
        return ComplexUtils.interleaved2Complex(d, 2);
    }

    public static Complex[][] interleaved2Complex(float[][] d, int interleavedDim) {
        Complex[][] c;
        if (interleavedDim > 1 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 1);
        }
        int width = d.length;
        int height = d[0].length;
        if (interleavedDim == 0) {
            c = new Complex[width / 2][height];
            for (int x = 0; x < width / 2; ++x) {
                for (int y = 0; y < height; ++y) {
                    c[x][y] = Complex.ofCartesian(d[x * 2][y], d[x * 2 + 1][y]);
                }
            }
        } else {
            c = new Complex[width][height / 2];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height / 2; ++y) {
                    c[x][y] = Complex.ofCartesian(d[x][y * 2], d[x][y * 2 + 1]);
                }
            }
        }
        return c;
    }

    public static Complex[][] interleaved2Complex(float[][] d) {
        return ComplexUtils.interleaved2Complex(d, 1);
    }

    public static Complex[][][] interleaved2Complex(float[][][] d, int interleavedDim) {
        Complex[][][] c;
        if (interleavedDim > 2 || interleavedDim < 0) {
            throw new OutOfRangeException(interleavedDim, (Number)0, 2);
        }
        int width = d.length;
        int height = d[0].length;
        int depth = d[0][0].length;
        if (interleavedDim == 0) {
            c = new Complex[width / 2][height][depth];
            for (int x = 0; x < width / 2; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        c[x][y][z] = Complex.ofCartesian(d[x * 2][y][z], d[x * 2 + 1][y][z]);
                    }
                }
            }
        } else if (interleavedDim == 1) {
            c = new Complex[width][height / 2][depth];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height / 2; ++y) {
                    for (int z = 0; z < depth; ++z) {
                        c[x][y][z] = Complex.ofCartesian(d[x][y * 2][z], d[x][y * 2 + 1][z]);
                    }
                }
            }
        } else {
            c = new Complex[width][height][depth / 2];
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < depth / 2; ++z) {
                        c[x][y][z] = Complex.ofCartesian(d[x][y][z * 2], d[x][y][z * 2 + 1]);
                    }
                }
            }
        }
        return c;
    }

    public static Complex[][][] interleaved2Complex(float[][][] d) {
        return ComplexUtils.interleaved2Complex(d, 2);
    }

    public static Complex[] split2Complex(double[] real, double[] imag) {
        int length = real.length;
        Complex[] c = new Complex[length];
        for (int n = 0; n < length; ++n) {
            c[n] = Complex.ofCartesian(real[n], imag[n]);
        }
        return c;
    }

    public static Complex[][] split2Complex(double[][] real, double[][] imag) {
        int length = real.length;
        Complex[][] c = new Complex[length][];
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.split2Complex(real[x], imag[x]);
        }
        return c;
    }

    public static Complex[][][] split2Complex(double[][][] real, double[][][] imag) {
        int length = real.length;
        Complex[][][] c = new Complex[length][][];
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.split2Complex(real[x], imag[x]);
        }
        return c;
    }

    public static Complex[] split2Complex(float[] real, float[] imag) {
        int length = real.length;
        Complex[] c = new Complex[length];
        for (int n = 0; n < length; ++n) {
            c[n] = Complex.ofCartesian(real[n], imag[n]);
        }
        return c;
    }

    public static Complex[][] split2Complex(float[][] real, float[][] imag) {
        int length = real.length;
        Complex[][] c = new Complex[length][];
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.split2Complex(real[x], imag[x]);
        }
        return c;
    }

    public static Complex[][][] split2Complex(float[][][] real, float[][][] imag) {
        int length = real.length;
        Complex[][][] c = new Complex[length][][];
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.split2Complex(real[x], imag[x]);
        }
        return c;
    }

    public static Complex[] initialize(Complex[] c) {
        int length = c.length;
        for (int x = 0; x < length; ++x) {
            c[x] = Complex.ZERO;
        }
        return c;
    }

    public static Complex[][] initialize(Complex[][] c) {
        int length = c.length;
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.initialize(c[x]);
        }
        return c;
    }

    public static Complex[][][] initialize(Complex[][][] c) {
        int length = c.length;
        for (int x = 0; x < length; ++x) {
            c[x] = ComplexUtils.initialize(c[x]);
        }
        return c;
    }

    public static double[] abs(Complex[] c) {
        int length = c.length;
        double[] d = new double[length];
        for (int x = 0; x < length; ++x) {
            d[x] = c[x].abs();
        }
        return d;
    }

    public static double[] arg(Complex[] c) {
        int length = c.length;
        double[] d = new double[length];
        for (int x = 0; x < length; ++x) {
            d[x] = c[x].getArgument();
        }
        return d;
    }
}

