/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.LanczosApproximation;
import org.apache.commons.numbers.gamma.RegularizedGamma;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class GammaDistribution
extends AbstractContinuousDistribution {
    private static final double LANCZOS_G = LanczosApproximation.g();
    private final double shape;
    private final double scale;
    private final double shiftedShape;
    private final double densityPrefactor1;
    private final double logDensityPrefactor1;
    private final double densityPrefactor2;
    private final double logDensityPrefactor2;
    private final double minY;
    private final double maxLogY;

    public GammaDistribution(double shape, double scale) {
        if (shape <= 0.0) {
            throw new DistributionException("Number {0} is negative", shape);
        }
        if (scale <= 0.0) {
            throw new DistributionException("Number {0} is negative", scale);
        }
        this.shape = shape;
        this.scale = scale;
        this.shiftedShape = shape + LANCZOS_G + 0.5;
        double aux = Math.E / (Math.PI * 2 * this.shiftedShape);
        this.densityPrefactor2 = shape * Math.sqrt(aux) / LanczosApproximation.value(shape);
        this.logDensityPrefactor2 = Math.log(shape) + 0.5 * Math.log(aux) - Math.log(LanczosApproximation.value(shape));
        this.densityPrefactor1 = this.densityPrefactor2 / scale * Math.pow(this.shiftedShape, -shape) * Math.exp(shape + LANCZOS_G);
        this.logDensityPrefactor1 = this.logDensityPrefactor2 - Math.log(scale) - Math.log(this.shiftedShape) * shape + shape + LANCZOS_G;
        this.minY = shape + LANCZOS_G - Math.log(Double.MAX_VALUE);
        this.maxLogY = Math.log(Double.MAX_VALUE) / (shape - 1.0);
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double y = x / this.scale;
        if (y <= this.minY || Math.log(y) >= this.maxLogY) {
            double aux1 = (y - this.shiftedShape) / this.shiftedShape;
            double aux2 = this.shape * (Math.log1p(aux1) - aux1);
            double aux3 = -y * (LANCZOS_G + 0.5) / this.shiftedShape + LANCZOS_G + aux2;
            return this.densityPrefactor2 / x * Math.exp(aux3);
        }
        return this.densityPrefactor1 * Math.exp(-y) * Math.pow(y, this.shape - 1.0);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double y = x / this.scale;
        if (y <= this.minY || Math.log(y) >= this.maxLogY) {
            double aux1 = (y - this.shiftedShape) / this.shiftedShape;
            double aux2 = this.shape * (Math.log1p(aux1) - aux1);
            double aux3 = -y * (LANCZOS_G + 0.5) / this.shiftedShape + LANCZOS_G + aux2;
            return this.logDensityPrefactor2 - Math.log(x) + aux3;
        }
        return this.logDensityPrefactor1 - y + Math.log(y) * (this.shape - 1.0);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : RegularizedGamma.P.value(this.shape, x / this.scale);
        return ret;
    }

    @Override
    public double getMean() {
        return this.shape * this.scale;
    }

    @Override
    public double getVariance() {
        return this.shape * this.scale * this.scale;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new AhrensDieterMarsagliaTsangGammaSampler(rng, GammaDistribution.this.scale, GammaDistribution.this.shape);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

