/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.long_long;

import io.virtdata.discrete.common.DiscreteLongLongSampler;
import io.virtdata.discrete.common.IntegerDistributionICDSource;
import io.virtdata.discrete.common.InterpolatingLongLongSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongUnaryOperator;
import org.apache.commons.statistics.distribution.DiscreteDistribution;

public class LongToLongDiscreteCurve
implements LongUnaryOperator {
    private DiscreteDistribution distribution;
    private LongUnaryOperator function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(LongToLongDiscreteCurve.COMPUTE);
            this.add(LongToLongDiscreteCurve.INTERPOLATE);
            this.add(LongToLongDiscreteCurve.MAP);
            this.add(LongToLongDiscreteCurve.HASH);
        }
    };

    public LongToLongDiscreteCurve(DiscreteDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        IntegerDistributionICDSource icdSource = new IntegerDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        this.function = interpolate ? new InterpolatingLongLongSampler(icdSource, 1000, hash) : new DiscreteLongLongSampler(icdSource, hash);
    }

    @Override
    public long applyAsLong(long operand) {
        return this.function.applyAsLong(operand);
    }
}

