/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.genetics;

import java.util.ArrayList;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.genetics.AbstractListChromosome;
import org.apache.commons.math4.genetics.BinaryChromosome;
import org.apache.commons.math4.genetics.Chromosome;
import org.apache.commons.math4.genetics.GeneticAlgorithm;
import org.apache.commons.math4.genetics.MutationPolicy;

public class BinaryMutation
implements MutationPolicy {
    @Override
    public Chromosome mutate(Chromosome original) throws MathIllegalArgumentException {
        if (!(original instanceof BinaryChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_BINARY_CHROMOSOME, new Object[0]);
        }
        BinaryChromosome origChrom = (BinaryChromosome)original;
        ArrayList newRepr = new ArrayList(origChrom.getRepresentation());
        int geneIndex = GeneticAlgorithm.getRandomGenerator().nextInt(origChrom.getLength());
        newRepr.set(geneIndex, (Integer)origChrom.getRepresentation().get(geneIndex) == 0 ? 1 : 0);
        AbstractListChromosome newChrom = origChrom.newFixedLengthChromosome(newRepr);
        return newChrom;
    }
}

