/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.int_double;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.continuous.int_double.IntToDoubleContinuousCurve;
import org.apache.commons.math4.distribution.EnumeratedRealDistribution;

@ThreadSafeMapper
@Categories(value={Category.distributions})
public class Enumerated
extends IntToDoubleContinuousCurve {
    @Examples(value={@Example(value={"Enumerated('1 2 3 4 5 6')", "a fair six-sided die roll", "[1-10]/"}), @Example(value={"Enumerated('1:2.0 2 3 4 5 6')", "an unfair six-sided die roll, where 1 has probability mass 2.0, and everything else has only 1.0"})})
    public Enumerated(String data, String ... mods) {
        super(new EnumeratedRealDistribution(Enumerated.parseWeights(data)[0], Enumerated.parseWeights(data)[1]), mods);
    }

    private static double[][] parseWeights(String input) {
        String[] entries = input.split("[;, ]");
        double[][] elements = new double[2][entries.length];
        block4: for (int i = 0; i < entries.length; ++i) {
            String[] parts = entries[i].split(":");
            elements[1][i] = 1.0;
            switch (parts.length) {
                case 2: {
                    elements[1][i] = Double.parseDouble(parts[1]);
                }
                case 1: {
                    elements[0][i] = Double.parseDouble(parts[0]);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unable to parse entry or weight from '" + entries[i] + "'");
                }
            }
        }
        return elements;
    }
}

