/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class ZigguratNormalizedGaussianSampler
implements NormalizedGaussianSampler {
    private static final double R = 3.442619855899;
    private static final double ONE_OVER_R = 0.29047645161474317;
    private static final double V = 0.00991256303526217;
    private static final double MAX;
    private static final double ONE_OVER_MAX;
    private static final int LEN = 128;
    private static final int LAST = 127;
    private static final long[] K;
    private static final double[] W;
    private static final double[] F;
    private final UniformRandomProvider rng;

    public ZigguratNormalizedGaussianSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public double sample() {
        long j = this.rng.nextLong();
        int i = (int)(j & 0x7FL);
        if (Math.abs(j) < K[i]) {
            return (double)j * W[i];
        }
        return this.fix(j, i);
    }

    public String toString() {
        return "Ziggurat normalized Gaussian deviate [" + this.rng.toString() + "]";
    }

    private double fix(long hz, int iz) {
        int izNew;
        long hzNew;
        do {
            double x = (double)hz * W[iz];
            if (iz == 0) {
                double y;
                while ((y = -Math.log(this.rng.nextDouble())) + y < (x = -Math.log(this.rng.nextDouble()) * 0.29047645161474317) * x) {
                }
                double out = 3.442619855899 + x;
                return hz > 0L ? out : -out;
            }
            if (F[iz] + this.rng.nextDouble() * (F[iz - 1] - F[iz]) < ZigguratNormalizedGaussianSampler.gauss(x)) {
                return x;
            }
            hzNew = this.rng.nextLong();
            izNew = (int)(hzNew & 0x7FL);
        } while (Math.abs(hzNew) >= K[izNew]);
        return (double)hzNew * W[izNew];
    }

    private static double gauss(double x) {
        return Math.exp(-0.5 * x * x);
    }

    static {
        double d;
        MAX = Math.pow(2.0, 63.0);
        ONE_OVER_MAX = 1.0 / MAX;
        K = new long[128];
        W = new double[128];
        F = new double[128];
        double t = d = 3.442619855899;
        double fd = ZigguratNormalizedGaussianSampler.gauss(d);
        double q = 0.00991256303526217 / fd;
        ZigguratNormalizedGaussianSampler.K[0] = (long)(d / q * MAX);
        ZigguratNormalizedGaussianSampler.K[1] = 0L;
        ZigguratNormalizedGaussianSampler.W[0] = q * ONE_OVER_MAX;
        ZigguratNormalizedGaussianSampler.W[127] = d * ONE_OVER_MAX;
        ZigguratNormalizedGaussianSampler.F[0] = 1.0;
        ZigguratNormalizedGaussianSampler.F[127] = fd;
        for (int i = 126; i >= 1; --i) {
            d = Math.sqrt(-2.0 * Math.log(0.00991256303526217 / d + fd));
            fd = ZigguratNormalizedGaussianSampler.gauss(d);
            ZigguratNormalizedGaussianSampler.K[i + 1] = (long)(d / t * MAX);
            t = d;
            ZigguratNormalizedGaussianSampler.F[i] = fd;
            ZigguratNormalizedGaussianSampler.W[i] = d * ONE_OVER_MAX;
        }
    }
}

